/*
Plugin Name: Youtube Video Gallery - Youtube Channel With Video Advertising
Description: Displays your actual complete youtube channel on your website just like its shown on youtube.
Author: BeeTeam368
Version: 2.0.8
License: Commercial
*/

;(function(factory) {
    'use strict';
    if(typeof define === 'function' && define.amd){
        define(['jquery'], factory);
    }else if (typeof exports !== 'undefined'){
        module.exports = factory(require('jquery'));
    }else{
        factory(jQuery);
    }
}(function($){
	'use strict';
			
	var ytGallery = window.ytGallery || {};
	
	/*
	<div class="test yt-defaults-videos-container yt-gallery-container-loading">
    	<div class="yt-gallery-load-icon yt-first-load-container"></div>
    </div>
	*/
	
  	ytGallery = (function(){
		function ytGallery(el, options){
			var _ = this;
			
			_.defaults = {
				api:							'https://www.googleapis.com/youtube/v3/',
				api_key:						'AIzaSyCbkF3ugWaz03OA-HFhovos3Gn82Cr6r8w',								
				data:							[],
												/*Example*/
												/*[
													{
														name:	'GAME',		
														urls:	'https://www.youtube.com/user/Battlefield\n'+
																'https://www.youtube.com/watch?v=jmKbDy45PXk&list=PLZeek85Kuka2o8JkicDxLOh47frrPi10X\n'+
																'https://www.youtube.com/channel/UCoDcFZ5KZ0KwBC_omalJuiA\n'+																
																'https://www.youtube.com/watch?v=8qZWJhnVcwM'
													},
																						
													{
														name:	'MUSIC',	
														urls:	'https://www.youtube.com/user/Battlefield'	
													},
													
													{
														name:	'FASHION',		
														urls:	'https://www.youtube.com/watch?v=oYTzuwG0rXg\n'+
																'https://www.youtube.com/watch?v=jmKbDy45PXk&list=PLZeek85Kuka2o8JkicDxLOh47frrPi10X'	
																
													},
													
													{
														name:	'TRAVEL',	
														urls:	'https://www.youtube.com/user/Battlefield'	
													},
												]*/
												/*Example*/
				
				prefix_class: 					'yt-gallery',
				
				time_locale:					'en',
				
				/*layout*/	
				layout: 						'grid', 			/*grid, list, carousel*/
				style:							'grid-classic-1',	/*grid: grid-classic-1, grid-special-1 | list: list-classic-1, list-classic-2, list-special-1*/
				
				carousel_config:				{														
													//slidesPerColumnFill	: 'row',
													spaceBetween		: 20,
													speed				: 600,
													autoplay			: '',
													autoplayStopOnLast	: true,
													slidesPerView		: 1,
													slidesPerColumn		: 1,
													breakpoints			: {},
													/*example*/
													/*{
														//when window width is <= 320px
														320: {
														  slidesPerView: 1,
														  spaceBetween: 10
														},
														//when window width is <= 480px
														480: {
														  slidesPerView: 2,
														  spaceBetween: 20
														},
														//when window width is <= 640px
														640: {
														  slidesPerView: 3,
														  spaceBetween: 30
														}
													}*/
													/*example*/
												},
				
				layout_play_mode: 				'popup', 	/*popup, inline, youtube*/
				layout_title: 					true,
				layout_title_one_line:			true,
				layout_description: 			true,
				layout_duration: 				true,
				layout_views_counter: 			true,
				layout_likes_counter: 			true,
				layout_dislikes_counter: 		true,
				layout_date: 					true,
				layout_comments_counter: 		true,
				layout_items_per_page:			12, 		/*max: 50*/
				layout_description_length:		60,
				layout_pagination:				'infinite', /*loadmore, infinite, prev-next*/				
				layout_play_btn:				true,
				layout_img_size:				'high', 	/*default (120,90)/ medium (320/180) / high (480,360) / standard (640,480) / maxres (1280,720)*/	
				layout_tabs:					true,
				
				layout_mobile: 					'default',
				layout_portrait_tablet:			'default',
				layout_landscape_tablet: 		'default',
				layout_small_desktop: 			'default',
				layout_medium_desktop: 			'default',
				layout_large_desktop: 			'default',
				layout_extra_large_desktop: 	'default',	
				/*layout*/
				
				player_autoplay: 				true,
				player_inline_close:			true,
				player_inline_light:			true,
				
				popup_ads:{
						enabled:				true,
						ad_type:				'ga', /*ga: google adsense, img: image*/
												
						google_ads_client_id:	'',
						google_ads_slot_id:		'',						
						
						ad_image:				[], /*[
														{img:'', link:''},
														{img:'', link:''}
													]*/
						/*img_link:				'',*/
						
				},		
				
				player_video_ads:{
						enabled:				true,
						ad_type:				'ga', /*ga: google adsense, img: image, vid: video*/
						
						google_ads_client_id:	'',
						google_ads_slot_id:		'',						
						
						ad_image:				[], /*[
														{img:'', link:''},
														{img:'', link:''}
													]*/
						/*img_link:				'',*/
						
						ad_video:				[], /*[
														{mp4:'', webm:'', ogv:'', link:''},
														{mp4:'', webm:'', ogv:'', link:''},
													]*/
						
						time_to_show_ads:		[0], 		/*second*/
						time_skip_ads:			5, 			/*second*/
						time_to_hide_ads:		10, 		/*second*/
						
				},								
				
				/*popup*/
				popup_width:					'',				
				popup_title: 					true,
				popup_channel_logo: 			true,
				popup_channel_name: 			true,
				popup_subscribe_button: 		true,
				popup_views_counter: 			true,
				popup_likes_counter: 			true,
				popup_dislikes_counter: 		true,
				popup_likes_ratio: 				true,
				popup_date: 					true,
				popup_description: 				true,
				popup_description_more_button: 	true,
				popup_comments: 				true,
				popup_share:					{
													show:		true,
													facebook:	true,
													twitter:	true,
													google:		true,
													linkedIn:	false,
													tumblr:		false,
													pinterest:	false,
													vk:			false,
													email:		true,
												},
				/*popup*/
				
				/*header*/
				header:								false,
				header_source:						'',
				header_style:						'default',
				header_logo:						true,
				header_channel_name:				true,
				header_channel_description:			true,
				header_videos_counter:				true,
				header_subscribers_counter:			true,
				header_views_counter:				true,
				header_subscribe_button:			true,
				
				header_custom_channel_name:			'',
				header_custom_channel_description:	'',
				header_custom_channel_logo:			'',
				header_custom_channel_background:	'',
				/*header*/
				
				/*static text*/
				text_views: 					'Views',
				text_comments: 					'Comments',
				text_likes: 					'Likes',
				text_dislikes: 					'Dislikes',				
				
				text_load_more:					'LOAD MORE',
				text_prev:						'PREV',
				text_next:						'NEXT',		
				text_already_loaded:			'ALL VIDEOS ARE ALREADY LOADED!',
				text_show_more:					'SHOW MORE',
				text_show_less:					'SHOW LESS',
				text_published_at:				'Published at',	
				text_view_all_replies:			'View all replies',	
				text_load_ads:					'Loading advertisement...',	
				text_skip_ad_in:				'Skip ad in',
				text_skip_ads:					'Skip Ad',
				/*static text*/	
				
				/*custom font*/
					/*main font*/
					main_font: 						'', /*Enter font-family name here. Google Fonts are supported. For example, if you choose "Open Sans" Google Font
														with font-weight 400,500,600, enter Open Sans:400,500,600*/
					main_font_size: 				'',
					main_font_letter_spacing: 		'',
					main_font_weight: 				'',
					main_font_style: 				'',
					main_font_transform: 			'',
					main_font_line_height: 			'',
					/*main font*/
					
					/*heading font*/
					heading_font: 					'',
					heading_font_size: 				'',
					heading_font_letter_spacing: 	'',
					heading_font_weight: 			'',
					heading_font_style: 			'',
					heading_font_transform: 		'',
					heading_font_line_height: 		'',
					/*heading font*/
					
					/*meta font*/
					meta_font: 						'',
					meta_font_size: 				'',
					meta_font_letter_spacing: 		'',
					meta_font_weight: 				'',
					meta_font_style: 				'',
					meta_font_transform: 			'',
					meta_font_line_height: 			'',
					/*meta font*/
				/*custom font*/
				
				/*custom color*/
					main_color:								'',
					
					background_color:						'',
					content_background_color:				'',
					item_background_color:					'',
					divider_color:							'',
					
					button_color:							'',
					button_background_color:				'',
					button_background_hover_color:			'',
					
					tab_color:								'',
					tab_hover_color:						'',
					
					title_color:							'',
					title_hover_color:						'',					
					text_color:								'',					
					meta_color:								'',
					
					header_logo_border_color:				'',
					header_channel_name_color:				'',
					header_channel_name_hover_color:		'',
					header_text_color:						'',
					header_meta_color:						'',
					header_meta_background_color:			'',
					
					popup_background:						'',
					
					popup_button_color:						'',
					popup_button_background_color:			'',
					popup_button_background_hover_color:	'',
					
					popup_heading_color:					'',
					popup_heading_hover_color:				'',					
					popup_link_color:						'',
					popup_link_hover_color:					'',
					popup_text_color:						'',					
					popup_meta_color:						'',
					popup_divider_color:					'',
					
				/*custom color*/
				
				debug:							false,						
			}
			
			if(typeof(options)==='object'){
				_.options = $.extend({}, _.defaults, options);
			}else{
				_.options = _.defaults;
			}
			
			if(_.options.layout==='carousel'){
				_.options.layout_items_per_page = _.options.carousel_config.slidesPerView * _.options.carousel_config.slidesPerColumn;
			}
			
			if(_.options.layout_items_per_page>50){
				_.options.layout_items_per_page = 50;
			}
			
			_.prefix_class 					= _.options.prefix_class;	
			_.global_user_channel_length 	= [];
			_.global_playlists 				= [];
			_.global_first_setup			= [];
			_.global_total_pages			= [];
			_.global_current_page			= [];
			_.global_last_page_items		= [];
			_.global_items					= [];
			_.group_active					= 0;
			_.global_all_data_loaded		= [];
			_.global_custom_class			= '';
			_.global_video_player			= [];
			_.global_video_ads				= [];
			_.global_video_current_time		= [];
			_.global_channel_info			= [];	
			
			_.$el 							= $(el);
			_.$el_section					= [];
			_.$el_list 						= [];			
			_.$el_pagination_wrap			= [];
			_.$el_loadbar					= [];
			_.$el_tab 						= [];
			
			_.$el_carousel					= [];
			_.carousel_resize				= [];
			_.mouse_events					= {x:-1,y:-1};
			
			_.container_class				= (_.prefix_class)+'-container-control';
			_.active_class					= (_.prefix_class)+'-active';
			_.hidden_class					= (_.prefix_class)+'-hidden';
			_.loading_class					= (_.prefix_class)+'-loading';
			_.stop_load_data_class			= (_.prefix_class)+'-stop-load-data';			
			
			_.data_group 					= _.auto_detect();
			
			_.init();
		}	
			
		return ytGallery;
	}());
	
	/*auto detect: video, playlist, channel*/
	ytGallery.prototype.auto_detect = function(){
		var _ 				= this,
			data 			= _.options.data,
			group_ids		= [];
			
		$.each(data, function(i, value){
			
			var group = value;
			
			if(typeof(group)==='object' && typeof(group.urls)!=='undefined'){
				var urls 					= group.urls.split('\n'),
					users_array				= [],
					users_urls_array		= [],
					
					channels_array			= [],
					channels_urls_array		= [],					
					
					playlists_array			= [],					
					videos_array			= [];
				
				$.each(urls, function(z, value){
					
					var url 	= value,
						t_id 	= '';
						
					if(_.youtube_validate(url)){
						if(url.indexOf('/user/')!==-1){
							t_id = _.youtube_user_parser(url);
							users_array.push(t_id);
							users_urls_array.push({url:_.build_url_user(t_id), sort_index:z});
														
						}else if(url.indexOf('/channel/')!==-1){
							t_id = _.youtube_channel_parser(url);
							channels_array.push(t_id);
							channels_urls_array.push({url:_.build_url_channel(t_id), sort_index:z});
							
						}else if(url.indexOf('list=')!==-1){
							t_id = _.youtube_playlist_parser(url);
							playlists_array.push({id:t_id, sort_index:z});								
											
						}else if(_.youtube_video_parser(url)!==''){
							t_id = _.youtube_video_parser(url);
							videos_array.push(t_id);
						}		
					}
					
				});
				
				group_ids.push({
					name:				(typeof(group.name)==='undefined' || group.name=='')?'Untitled':group.name,
					
					users_urls:			users_urls_array,
					users_length:		users_array.length,					
					
					channels_urls:		channels_urls_array,
					channels_length:	channels_array.length,
					
					playlists:			playlists_array,					
					playlists_length:	playlists_array.length,
					
					videos:				videos_array,
					videos_length:		videos_array.length,
				});
			}
		});	
		
		return group_ids;
	}
		/*get user ID*/
		ytGallery.prototype.youtube_user_parser = function(url){
			var _ 			= this,
				idString 	= url.slice(url.indexOf('/user/')+6);
							
			if(idString!==''){
				return (idString.split('/'))[0];
			}		
			return '';	
		}/*get user ID*/
		
		/*get channel ID*/
		ytGallery.prototype.youtube_channel_parser = function(url){
			var _ 			= this,
				idString 	= url.slice(url.indexOf('/channel/')+9);
				
			if(idString!==''){
				return (idString.split('/'))[0];
			}		
			return '';		
		}/*get channel ID*/
		
		/*get playlist ID*/
		ytGallery.prototype.youtube_playlist_parser = function(url){
			var _ 		= this,
				reg 	= new RegExp("[&?]list=([a-z0-9_-]+)","i"),
				match 	= reg.exec(url);
				
			if(match&&match[1].length>0){
				return match[1];
			}
			return '';
		}/*get playlist ID*/
		
		/*get video ID*/
		ytGallery.prototype.youtube_video_parser = function(url){
			var _ 		= this,
				regExp 	= /^.*((youtu.be\/)|(v\/)|(\/u\/\w\/)|(embed\/)|(watch\?))\??v?=?([^#\&\?]*).*/,
				match 	= url.match(regExp);
			return (match&&match[7].length==11)? match[7] : '';
		}/*get video ID*/
	
		/*youtube URL Validate*/
		ytGallery.prototype.youtube_validate = function(url){
			var _ 		= this,
				regExp 	= /^(?:https?:\/\/)?(?:www\.)?youtube\.com|youtu\.be(?:\S+)?$/;
			return url.match(regExp)&&url.match(regExp).length>0;		
		}/*youtube URL Validate*/	
		
		/*build url user*/
		ytGallery.prototype.build_url_user = function(id){
			var _ = this;
			return (_.options.api)+'channels?part=snippet,contentDetails,brandingSettings,statistics&forUsername='+id+'&key='+(_.options.api_key);
		}/*build url user*/	
		
		/*build url channel*/
		ytGallery.prototype.build_url_channel = function(id){
			var _ = this;
			return (_.options.api)+'channels?id='+id+'&part=snippet,contentDetails,brandingSettings,statistics&maxResults=1&key='+(_.options.api_key);
		}/*build url channel*/
		
		/*build url comment*/
			ytGallery.prototype.build_url_comment = function(id, pageToken){				
				var _ = this,
					pt_string = '';
			
				if(typeof(pageToken)!=='undefined' && pageToken!==''){
					pt_string='&pageToken='+pageToken;
				}
								
				return (_.options.api)+'commentThreads?videoId='+id+'&part=id,replies,snippet&textFormat=html&maxResults=10&order=time&key='+(_.options.api_key)+(pt_string);
			}		
		/*build url comment*/
	/*auto detect: video, playlist, channel*/
	
	/*init function*/
	ytGallery.prototype.init = function(){
		var _ = this;
		
		if(_.options.api_key==='' || !Array.isArray(_.data_group)){			
			return;
		}
		
		moment.locale(_.options.time_locale);
		
		/*mouse event*/
		$(document).on('mousemove', function(event){
			_.mouse_events.x = event.pageX;
			_.mouse_events.y = event.pageY;
		});
		/*mouse event*/
		
		_.header_create();
		_.html_builder();
			
		/*init*/		
		_.$el.trigger('init', []);/*init*/
	}/*init function*/
	
	/*API Error*/
	ytGallery.prototype.api_error = function(index, data){
		var _ = this;
		
		if(typeof(data.error)!=='undefined'){
			_.$el_section[index].html('Error code: '+(data.error.code)+' | Error message: '+(data.error.message)+' | Reason: '+(data.error.errors[0].reason));
			_.loading_bar(index, '100%');
			return false;
		}
		
		return true;
	}
	/*API Error*/
	
	/*html builder: 1*/
	ytGallery.prototype.html_builder = function(){
		
		var _ 			= this;
		
		if(_.options.debug){
			console.log('Setup: 1 - before');
		}		
		
		var	data		= _.data_group,
			data_length	= data.length,
			columns		= _.columns(),
			int_random 	= Math.floor((Math.random() * 10000) + 10)+(new Date().getTime());
			
			_.global_custom_class = (_.prefix_class)+'-'+(int_random);
			_.custom_css(_.global_custom_class);	
			
		
		_.$el.addClass((_.prefix_class)+'-container '+(_.container_class)+' '+_.global_custom_class);
		
		if(_.options.layout_tabs && _.$el_tab.length===0){
			
			_.$el.append('<div class="'+(_.prefix_class)+'-tab-group '+(_.prefix_class)+'-tab-group-control"></div>');
			var $tab_group = $('.'+(_.prefix_class)+'-tab-group-control', _.$el);
			
			for(var i=0;i<data_length;i++){
				var tab_active = '';
				if(i==0){
					tab_active = ' '+(_.active_class);
				}
				var tab_item =	'<div class="'+(_.prefix_class)+'-tab-section '+(_.prefix_class)+'-tab-section-control'+(tab_active)+'" data-index="'+(i)+'">\
									<span class="'+(_.prefix_class)+'-tab-content '+(_.prefix_class)+'-tab-content-control">'+(data[i].name)+'</span>\
								</div>';
				$tab_group.append(tab_item);
				
				_.$el_tab[i] = $('.'+(_.prefix_class)+'-tab-group-section-control[data-index="'+(i)+'"] .'+(_.prefix_class)+'-tab-content-control', _.$el);
			}			
		}
		
		if(_.$el_list.length===0){
			
			_.$el.append('<div class="'+(_.prefix_class)+'-listing-wrap '+(_.prefix_class)+'-listing-wrap-control'+(columns)+' equal-height-columns"></div>');
			
			var $wrap = $('.'+(_.prefix_class)+'-listing-wrap-control', _.$el);
			
			for(var i=0;i<data_length;i++){
				var section_active = '';
				if(i==0){
					section_active = ' '+(_.active_class);
				}
				
				var wrap_slide = '';
				
				if(_.options.layout==='carousel'){
					wrap_slide+='<div class="swiper-container '+(_.prefix_class)+'-carousel-container-control'+(section_active)+'">';
						wrap_slide+='<div class="swiper-wrapper '+(_.prefix_class)+'-carousel-wrapper-control">';
						wrap_slide+='</div>';
					wrap_slide+='</div>';
				}
								
				var wrap_item =	'<div class="'+(_.prefix_class)+'-listing-section '+(_.prefix_class)+'-listing-section-control'+(section_active)+'" data-index="'+(i)+'">\
									<div class="'+(_.prefix_class)+'-section-loading '+(_.prefix_class)+'-section-loading-control">\
										<span class="'+(_.prefix_class)+'-loading-bar-percent"></span>\
										<div class="'+(_.prefix_class)+'-load-icon"></div>\
									</div>\
									<div class="'+(_.prefix_class)+'-details-content '+(_.prefix_class)+'-details-content-control">'+(wrap_slide)+'</div>\
								</div>';									
				$wrap.append(wrap_item);
				
				_.$el_section[i] 	= $('.'+(_.prefix_class)+'-listing-section-control[data-index="'+(i)+'"]', _.$el);
				_.$el_list[i] 		= $('.'+(_.prefix_class)+'-details-content-control', _.$el_section[i]);
				_.$el_loadbar[i] 	= $('.'+(_.prefix_class)+'-section-loading-control', _.$el_section[i]);		
			}
						
			setTimeout(function(){
				_.$el.removeClass((_.prefix_class)+'-container-loading').find('.'+(_.prefix_class)+'-load-icon.yt-first-load-container').remove();
				_.loading_bar(0, '10%');
				_.get_data_source(0);
				_.tab_control();	
			},100);	
					
		}else{
			//next page
		}
		
		if(_.options.debug){
			console.log('Setup: 1 - after');
		}
	}
		/*css custom*/
		ytGallery.prototype.custom_css = function(custom_class){
			var _ = this;
			
			$('#cc_c_'+(custom_class)).remove();
			$('#lc_c_'+(custom_class)).remove();
			var cc_css = '',
				font_google = [];
			
			/*main font*/
			var main_f_check 				= 0,
				main_font 					= '',
				main_font_size 				= '',
				main_font_letter_spacing 	= '',
				main_font_weight 			= '',
				main_font_style 			= '',
				main_font_transform 		= '',
				main_font_line_height 		= '';
				
			if(_.options.main_font!==''){
				main_f_check = 1;
				font_google.push(_.options.main_font);
				main_font = 'font-family:"'+(_.options.main_font.split(':')[0])+'" !important;';
			}
			if(_.options.main_font_size!==''){
				main_f_check = 1;
				main_font_size = 'font-size:'+(_.options.main_font_size)+' !important;';
			}
			if(_.options.main_font_letter_spacing!==''){
				main_f_check = 1;
				main_font_letter_spacing = 'letter-spacing:'+(_.options.main_font_letter_spacing)+' !important;';
			}
			if(_.options.main_font_weight!==''){
				main_f_check = 1;
				main_font_weight = 'font-weight:'+(_.options.main_font_weight)+' !important;';
			}
			if(_.options.main_font_style!==''){
				main_f_check = 1;
				main_font_style = 'font-style:'+(_.options.main_font_style)+' !important;';
			}
			if(_.options.main_font_transform!==''){
				main_f_check = 1;
				main_font_transform = 'text-transform:'+(_.options.main_font_transform)+' !important;';
			}
			if(_.options.main_font_line_height!==''){
				main_f_check = 1;
				main_font_line_height = 'line-height:'+(_.options.main_font_line_height)+' !important;';
			}
			
			if(main_f_check===1){
				cc_css+='.'+(custom_class)+'.yt-defaults-videos-container,\
						 .'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-pagination-wrap .'+(_.prefix_class)+'-loadmore-btn,\
						 .'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-pagination-wrap:not(.'+(_.prefix_class)+'-cr-style) .'+(_.prefix_class)+'-next,\
						 .'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-pagination-wrap:not(.'+(_.prefix_class)+'-cr-style) .'+(_.prefix_class)+'-prev,\
						 .'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-grid .'+(_.prefix_class)+'-item{\
							'+(main_font)+(main_font_size)+(main_font_letter_spacing)+(main_font_weight)+(main_font_style)+(main_font_transform)+(main_font_line_height)+'\
						}';
				
				if(_.options.main_font_size!==''){		
					cc_css+='.'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-video-ads .'+(_.prefix_class)+'-skip-ads{\
								font-size:calc('+(_.options.main_font_size)+' * 1.15) !important;\
								font-size:-webkit-calc('+(_.options.main_font_size)+' * 1.15) !important;\
								font-size:-moz-calc('+(_.options.main_font_size)+' * 1.15) !important;\
								font-size:-ms-calc('+(_.options.main_font_size)+' * 1.15) !important;\
								font-size:-o-calc('+(_.options.main_font_size)+' * 1.15) !important;\
							}';
					cc_css+='.'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-popup-more{\
								font-size:calc('+(_.options.main_font_size)+' * 0.85) !important;\
								font-size:-webkit-calc('+(_.options.main_font_size)+' * 0.85) !important;\
								font-size:-moz-calc('+(_.options.main_font_size)+' * 0.85) !important;\
								font-size:-ms-calc('+(_.options.main_font_size)+' * 0.85) !important;\
								font-size:-o-calc('+(_.options.main_font_size)+' * 0.85) !important;\
							}';	
				}
			}
			/*main font*/
			
			/*heading font*/
			var heading_f_check 				= 0,
				heading_font 					= '',
				heading_font_size 				= '',
				heading_font_letter_spacing 	= '',
				heading_font_weight 			= '',
				heading_font_style 				= '',
				heading_font_transform 			= '',
				heading_font_line_height 		= '';
			
			if(_.options.heading_font!==''){
				heading_f_check = 1;
				font_google.push(_.options.heading_font);
				heading_font = 'font-family:"'+(_.options.heading_font.split(':')[0])+'" !important;';
			}
			if(_.options.heading_font_size!==''){
				heading_f_check = 1;
				heading_font_size = 'font-size:'+(_.options.heading_font_size)+' !important;';
			}
			if(_.options.heading_font_letter_spacing!==''){
				heading_f_check = 1;
				heading_font_letter_spacing = 'letter-spacing:'+(_.options.heading_font_letter_spacing)+' !important;';
			}
			if(_.options.heading_font_weight!==''){
				heading_f_check = 1;
				heading_font_weight = 'font-weight:'+(_.options.heading_font_weight)+' !important;';
			}
			if(_.options.heading_font_style!==''){
				heading_f_check = 1;
				heading_font_style = 'font-style:'+(_.options.heading_font_style)+' !important;';
			}
			if(_.options.heading_font_transform!==''){
				heading_f_check = 1;
				heading_font_transform = 'text-transform:'+(_.options.heading_font_transform)+' !important;';
			}
			if(_.options.heading_font_line_height!==''){
				heading_f_check = 1;
				heading_font_line_height = 'line-height:'+(_.options.heading_font_line_height)+' !important;';
			}
			
			if(heading_f_check===1){
				cc_css+='.'+(custom_class)+'.yt-defaults-videos-container h3.'+(_.prefix_class)+'-title,\
						 .'+(custom_class)+'.yt-defaults-videos-container h3.'+(_.prefix_class)+'-title a,\
						 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup h1.'+(_.prefix_class)+'-video-title,\
						 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-channel-info .'+(_.prefix_class)+'-channel-subs .'+(_.prefix_class)+'-channel-name,\
						 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-channel-info .'+(_.prefix_class)+'-channel-subs .'+(_.prefix_class)+'-channel-name .'+(_.prefix_class)+'-channel-link,\
						 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-comment-block .'+(_.prefix_class)+'-comment-content .'+(_.prefix_class)+'-comment-entry .'+(_.prefix_class)+'-comment-author,\
						.'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-comment-block .'+(_.prefix_class)+'-comment-content .'+(_.prefix_class)+'-comment-entry .'+(_.prefix_class)+'-comment-author .'+(_.prefix_class)+'-channel-link,\
						.'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-header-container .'+(_.prefix_class)+'-header-content .'+(_.prefix_class)+'-header-body .'+(_.prefix_class)+'-header-title,\
						.'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-header-container .'+(_.prefix_class)+'-header-content .'+(_.prefix_class)+'-header-body .'+(_.prefix_class)+'-header-title a,\
						.'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-tab-section>span{\
							'+(heading_font)+(heading_font_size)+(heading_font_letter_spacing)+(heading_font_weight)+(heading_font_style)+(heading_font_transform)+(heading_font_line_height)+'\
						}';
						
				if(_.options.heading_font_size!==''){
					cc_css+='.'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-tab-section>span{\
								font-size:calc('+(_.options.heading_font_size)+' * 1.15) !important;\
								font-size:-webkit-calc('+(_.options.heading_font_size)+' * 1.15) !important;\
								font-size:-moz-calc('+(_.options.heading_font_size)+' * 1.15) !important;\
								font-size:-ms-calc('+(_.options.heading_font_size)+' * 1.15) !important;\
								font-size:-o-calc('+(_.options.heading_font_size)+' * 1.15) !important;\
							}';
							
					cc_css+='.'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup h1.'+(_.prefix_class)+'-video-title{\
								font-size:calc('+(_.options.heading_font_size)+' * 1.34) !important;\
								font-size:-webkit-calc('+(_.options.heading_font_size)+' * 1.34) !important;\
								font-size:-moz-calc('+(_.options.heading_font_size)+' * 1.34) !important;\
								font-size:-ms-calc('+(_.options.heading_font_size)+' * 1.34) !important;\
								font-size:-o-calc('+(_.options.heading_font_size)+' * 1.34) !important;\
							}';
					cc_css+='.'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-channel-info .'+(_.prefix_class)+'-channel-subs .'+(_.prefix_class)+'-channel-name,\
							 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-channel-info .'+(_.prefix_class)+'-channel-subs .'+(_.prefix_class)+'-channel-name .'+(_.prefix_class)+'-channel-link{\
								font-size:calc('+(_.options.heading_font_size)+' * 0.93) !important;\
								font-size:-webkit-calc('+(_.options.heading_font_size)+' * 0.93) !important;\
								font-size:-moz-calc('+(_.options.heading_font_size)+' * 0.93) !important;\
								font-size:-ms-calc('+(_.options.heading_font_size)+' * 0.93) !important;\
								font-size:-o-calc('+(_.options.heading_font_size)+' * 0.93) !important;\
							}';
					cc_css+='.'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-comment-block .'+(_.prefix_class)+'-comment-content .'+(_.prefix_class)+'-comment-entry .'+(_.prefix_class)+'-comment-author,\
							 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-comment-block .'+(_.prefix_class)+'-comment-content .'+(_.prefix_class)+'-comment-entry .'+(_.prefix_class)+'-comment-author .'+(_.prefix_class)+'-channel-link{\
								font-size:calc('+(_.options.heading_font_size)+' * 0.86) !important;\
								font-size:-webkit-calc('+(_.options.heading_font_size)+' * 0.86) !important;\
								font-size:-moz-calc('+(_.options.heading_font_size)+' * 0.86) !important;\
								font-size:-ms-calc('+(_.options.heading_font_size)+' * 0.86) !important;\
								font-size:-o-calc('+(_.options.heading_font_size)+' * 0.86) !important;\
							}';							
					cc_css+='.'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-header-container .'+(_.prefix_class)+'-header-content .'+(_.prefix_class)+'-header-body .'+(_.prefix_class)+'-header-title,\
							 .'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-header-container .'+(_.prefix_class)+'-header-content .'+(_.prefix_class)+'-header-body .'+(_.prefix_class)+'-header-title a{\
								font-size:calc('+(_.options.heading_font_size)+' * 1.34) !important;\
								font-size:-webkit-calc('+(_.options.heading_font_size)+' * 1.34) !important;\
								font-size:-moz-calc('+(_.options.heading_font_size)+' * 1.34) !important;\
								font-size:-ms-calc('+(_.options.heading_font_size)+' * 1.34) !important;\
								font-size:-o-calc('+(_.options.heading_font_size)+' * 1.34) !important;\
							}';							
				}						
			}
			/*heading font*/
			
			/*meta font*/
			var meta_f_check 				= 0,
				meta_font 					= '',
				meta_font_size 				= '',
				meta_font_letter_spacing 	= '',
				meta_font_weight 			= '',
				meta_font_style 			= '',
				meta_font_transform 		= '',
				meta_font_line_height 		= '';
			
			if(_.options.meta_font!==''){
				meta_f_check = 1;
				font_google.push(_.options.meta_font);
				meta_font = 'font-family:"'+(_.options.meta_font.split(':')[0])+'" !important;';
			}
			if(_.options.meta_font_size!==''){
				meta_f_check = 1;
				meta_font_size = 'font-size:'+(_.options.meta_font_size)+' !important;';
			}
			if(_.options.meta_font_letter_spacing!==''){
				meta_f_check = 1;
				meta_font_letter_spacing = 'letter-spacing:'+(_.options.meta_font_letter_spacing)+' !important;';
			}
			if(_.options.meta_font_weight!==''){
				meta_f_check = 1;
				meta_font_weight = 'font-weight:'+(_.options.meta_font_weight)+' !important;';
			}
			if(_.options.meta_font_style!==''){
				meta_f_check = 1;
				meta_font_style = 'font-style:'+(_.options.meta_font_style)+' !important;';
			}
			if(_.options.meta_font_transform!==''){
				meta_f_check = 1;
				meta_font_transform = 'text-transform:'+(_.options.meta_font_transform)+' !important;';
			}
			if(_.options.meta_font_line_height!==''){
				meta_f_check = 1;
				meta_font_line_height = 'line-height:'+(_.options.meta_font_line_height)+' !important;';
			}
			
			if(meta_f_check===1){				
				cc_css+='.'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-metas .'+(_.prefix_class)+'-metas-wrap>*,\
						 .'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-metas .'+(_.prefix_class)+'-metas-wrap a,\
						 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-publishedAt,\
						 .'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-duration,\
						 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-channel-info .'+(_.prefix_class)+'-channel-metas .'+(_.prefix_class)+'-video-views,\
						 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-channel-info .'+(_.prefix_class)+'-channel-metas .'+(_.prefix_class)+'-metas .'+(_.prefix_class)+'-metas-wrap>*,\
						 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-channel-info .'+(_.prefix_class)+'-channel-metas .'+(_.prefix_class)+'-metas .'+(_.prefix_class)+'-metas-wrap a,\
						 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-comment-block .'+(_.prefix_class)+'-comment-content .'+(_.prefix_class)+'-comment-entry .'+(_.prefix_class)+'-comment-author .'+(_.prefix_class)+'-publishedAt{\
								'+(meta_font)+(meta_font_size)+(meta_font_letter_spacing)+(meta_font_weight)+(meta_font_style)+(meta_font_transform)+(meta_font_line_height)+'\
							}';
				
				if(_.options.meta_font_size!==''){
					cc_css+='.'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-metas .'+(_.prefix_class)+'-metas-wrap>* .fa{\
								font-size:calc('+(_.options.meta_font_size)+' * 1.17) !important;\
								font-size:-webkit-calc('+(_.options.meta_font_size)+' * 1.17) !important;\
								font-size:-moz-calc('+(_.options.meta_font_size)+' * 1.17) !important;\
								font-size:-ms-calc('+(_.options.meta_font_size)+' * 1.17) !important;\
								font-size:-o-calc('+(_.options.meta_font_size)+' * 1.17) !important;\
							}';	
							
					cc_css+='.'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-metas .'+(_.prefix_class)+'-metas-wrap>* .fa{\
								font-size:calc('+(_.options.meta_font_size)+' * 1.17) !important;\
								font-size:-webkit-calc('+(_.options.meta_font_size)+' * 1.17) !important;\
								font-size:-moz-calc('+(_.options.meta_font_size)+' * 1.17) !important;\
								font-size:-ms-calc('+(_.options.meta_font_size)+' * 1.17) !important;\
								font-size:-o-calc('+(_.options.meta_font_size)+' * 1.17) !important;\
							}';	
							
					cc_css+='.'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-channel-info .'+(_.prefix_class)+'-channel-metas .'+(_.prefix_class)+'-video-views{\
									font-size:calc('+(_.options.meta_font_size)+' * 1.5) !important;\
									font-size:-webkit-calc('+(_.options.meta_font_size)+' * 1.5) !important;\
									font-size:-moz-calc('+(_.options.meta_font_size)+' * 1.5) !important;\
									font-size:-ms-calc('+(_.options.meta_font_size)+' * 1.5) !important;\
									font-size:-o-calc('+(_.options.meta_font_size)+' * 1.5) !important;\
								}';
								
					cc_css+='.'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-publishedAt{\
									font-size:calc('+(_.options.meta_font_size)+' * 1.17) !important;\
									font-size:-webkit-calc('+(_.options.meta_font_size)+' * 1.17) !important;\
									font-size:-moz-calc('+(_.options.meta_font_size)+' * 1.17) !important;\
									font-size:-ms-calc('+(_.options.meta_font_size)+' * 1.17) !important;\
									font-size:-o-calc('+(_.options.meta_font_size)+' * 1.17) !important;\
							}';
					cc_css+='.'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-channel-info .'+(_.prefix_class)+'-channel-metas .'+(_.prefix_class)+'-metas .'+(_.prefix_class)+'-metas-wrap>*,\
						 	 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-channel-info .'+(_.prefix_class)+'-channel-metas .'+(_.prefix_class)+'-metas .'+(_.prefix_class)+'-metas-wrap a{\
									font-size:calc('+(_.options.meta_font_size)+' * 1.17) !important;\
									font-size:-webkit-calc('+(_.options.meta_font_size)+' * 1.17) !important;\
									font-size:-moz-calc('+(_.options.meta_font_size)+' * 1.17) !important;\
									font-size:-ms-calc('+(_.options.meta_font_size)+' * 1.17) !important;\
									font-size:-o-calc('+(_.options.meta_font_size)+' * 1.17) !important;\
							}';
					
					cc_css+='.'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-channel-info .'+(_.prefix_class)+'-channel-metas .'+(_.prefix_class)+'-metas .'+(_.prefix_class)+'-metas-wrap>* .fa{\
									font-size:calc('+(_.options.meta_font_size)+' * 1.17 * 1.17) !important;\
									font-size:-webkit-calc('+(_.options.meta_font_size)+' * 1.17 * 1.17) !important;\
									font-size:-moz-calc('+(_.options.meta_font_size)+' * 1.17 * 1.17) !important;\
									font-size:-ms-calc('+(_.options.meta_font_size)+' * 1.17 * 1.17) !important;\
									font-size:-o-calc('+(_.options.meta_font_size)+' * 1.17 * 1.17) !important;\
							}';							
				}
			}
			/*meta font*/	
					
			if(font_google.length>0){
				var link_font = $('<link>').attr({
					'id': 		'lc_c_'+(custom_class),
					'rel': 		'stylesheet',
					'href': 	'https://fonts.googleapis.com/css?family='+encodeURI(font_google.join('|')),
					'type': 	'text/css',
					'media':	'all'
				});
				$('head').append(link_font);
			}
			
			/*custom color*/			
			if(_.options.main_color!=''){
				cc_css+='.'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-section-loading .'+(_.prefix_class)+'-loading-bar-percent,\
						 .'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-tab-section.'+(_.active_class)+'>span:before,\
						 .'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-button-control-style:hover > span:before,\
						 .'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-button-control-style:hover > span:after,\
						 .'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-video-ads .'+(_.prefix_class)+'-close-load-ads,\
						 .'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-video-ads .'+(_.prefix_class)+'-skip-ads.'+(_.active_class)+':not(:hover),\
						 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-channel-info .'+(_.prefix_class)+'-channel-metas .'+(_.prefix_class)+'-like-bar span,\
						 .'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-pagination-wrap .'+(_.prefix_class)+'-loadmore-btn:not(:hover),\
						 .'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-pagination-wrap .'+(_.prefix_class)+'-next:not(:hover),\
						 .'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-pagination-wrap .'+(_.prefix_class)+'-prev:not(:hover){\
							background-color:'+(_.options.main_color)+' !important;\
						}';
						
				cc_css+='.'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-popup-more:hover,\
						 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-comment-block .'+(_.prefix_class)+'-comment-reply-showmore span:hover,\
						 .'+(custom_class)+'.yt-defaults-videos-container h3.'+(_.prefix_class)+'-title a:hover,\
						 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-channel-info .'+(_.prefix_class)+'-channel-subs .'+(_.prefix_class)+'-channel-name .'+(_.prefix_class)+'-channel-link:hover,\
						 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-comment-block .'+(_.prefix_class)+'-comment-content .'+(_.prefix_class)+'-comment-entry .'+(_.prefix_class)+'-comment-author .'+(_.prefix_class)+'-channel-link:hover,\
						 .'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-tab-section:not(.'+(_.active_class)+'):hover>span,\
						 .'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-button-control-style:hover,\
						 .'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-player.'+(_.prefix_class)+'-light-open .'+(_.prefix_class)+'-player-light,\
						 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-popup-description a:hover,\
						 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-comment-block .'+(_.prefix_class)+'-comment-content .'+(_.prefix_class)+'-comment-entry .'+(_.prefix_class)+'-comment-text a:hover{\
							color:'+(_.options.main_color)+' !important;\
						}';
				
				cc_css+='.'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-load-icon{\
							border-left-color:'+(_.options.main_color)+' !important;\
						}';
			}
			
			if(_.options.background_color!=''){
				cc_css+='.'+(custom_class)+'.yt-defaults-videos-container{\
							background-color:'+(_.options.background_color)+' !important;\
						}';
			}
			
			if(_.options.content_background_color!=''){
				cc_css+='.'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-container-loading,\
						 .'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-listing-section,\
						 .'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-tab-section.'+(_.active_class)+',\
						 .'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-tab-section.'+(_.active_class)+'>span:after,\
						 .'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-header-container .'+(_.prefix_class)+'-header-background{\
							background-color:'+(_.options.content_background_color)+' !important;\
						}\
						@media(max-width:767px){\
							.'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-tab-section{\
								border-color:'+(_.options.content_background_color)+' !important;\
							}\
						}';
			}
			
			if(_.options.item_background_color!=''){
				cc_css+='.'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-grid .'+(_.prefix_class)+'-entry-wrapper,\
						 .'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-list.'+(_.prefix_class)+'-list-special-1 .'+(_.prefix_class)+'-content{\
							background-color:'+(_.options.item_background_color)+' !important;\
						}';
			}
			
			if(_.options.divider_color!=''){
				cc_css+='.'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-header-container{\
							border-bottom-color:'+(_.options.divider_color)+' !important;\
						}';
			}
			
			if(_.options.button_color!=''){
				cc_css+='.'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-pagination-wrap .'+(_.prefix_class)+'-loadmore-btn,\
				 		 .'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-pagination-wrap .'+(_.prefix_class)+'-next,\
				 		 .'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-pagination-wrap .'+(_.prefix_class)+'-prev{\
						 	color:'+(_.options.button_color)+' !important;\
						}';
				
				cc_css+='.'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-pagination-wrap .'+(_.prefix_class)+'-loadmore-btn .'+(_.prefix_class)+'-loadmore-dot>span,\
				 		 .'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-pagination-wrap .'+(_.prefix_class)+'-next .'+(_.prefix_class)+'-loadmore-dot>span,\
				 		 .'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-pagination-wrap .'+(_.prefix_class)+'-prev .'+(_.prefix_class)+'-loadmore-dot>span{\
						 	background-color:'+(_.options.button_color)+' !important;\
						 }';
			}
			if(_.options.button_background_color!=''){
				cc_css+='.'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-pagination-wrap .'+(_.prefix_class)+'-loadmore-btn:not(:hover),\
				 		 .'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-pagination-wrap .'+(_.prefix_class)+'-next:not(:hover),\
				 		 .'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-pagination-wrap .'+(_.prefix_class)+'-prev:not(:hover){\
						 	background-color:'+(_.options.button_background_color)+' !important;\
						 }';
				cc_css+='.'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-load-icon{\
							border-left-color:'+(_.options.button_background_color)+' !important;\
						}';		 
			}
			if(_.options.button_background_hover_color!=''){
				cc_css+='.'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-pagination-wrap .'+(_.prefix_class)+'-loadmore-btn:hover,\
				 		 .'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-pagination-wrap .'+(_.prefix_class)+'-next:hover,\
				 		 .'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-pagination-wrap .'+(_.prefix_class)+'-prev:hover,\
						 .'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-pagination-wrap.'+(_.loading_class)+' .'+(_.prefix_class)+'-loadmore-btn,\
						 .'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-pagination-wrap.'+(_.loading_class)+' .'+(_.prefix_class)+'-prev,\
						 .'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-pagination-wrap.'+(_.loading_class)+' .'+(_.prefix_class)+'-next{\
						 	background-color:'+(_.options.button_background_hover_color)+' !important;\
						 }';
				cc_css+='.'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-load-icon{\
							border-top-color:'+(_.options.button_background_hover_color)+' !important;\
							border-right-color:'+(_.options.button_background_hover_color)+' !important;\
							border-bottom-color:'+(_.options.button_background_hover_color)+' !important;\
						}';		 
			}
			
			if(_.options.tab_color!=''){
				cc_css+='.'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-tab-section:not(:hover)>span,\
						 .'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-tab-section.'+(_.active_class)+'>span{\
							color:'+(_.options.tab_color)+' !important;\
						}';
			}
			if(_.options.tab_hover_color!=''){
				cc_css+='.'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-tab-section:not(.'+(_.active_class)+'):hover>span,\
						 .'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-tab-section.'+(_.active_class)+'>span{\
							color:'+(_.options.tab_hover_color)+' !important;\
						}';
			}
			
			if(_.options.title_color!=''){
				cc_css+='.'+(custom_class)+'.yt-defaults-videos-container h3.'+(_.prefix_class)+'-title,\
				 		 .'+(custom_class)+'.yt-defaults-videos-container h3.'+(_.prefix_class)+'-title a:not(:hover),\
						 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-video-title,\
						 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-channel-info .'+(_.prefix_class)+'-channel-subs .'+(_.prefix_class)+'-channel-name,\
						 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-channel-info .'+(_.prefix_class)+'-channel-subs .'+(_.prefix_class)+'-channel-name .'+(_.prefix_class)+'-channel-link:not(:hover),\
						 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-comment-block .'+(_.prefix_class)+'-comment-content .'+(_.prefix_class)+'-comment-entry .'+(_.prefix_class)+'-comment-author,\
						 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-comment-block .'+(_.prefix_class)+'-comment-content .'+(_.prefix_class)+'-comment-entry .'+(_.prefix_class)+'-comment-author .'+(_.prefix_class)+'-channel-link:not(:hover){\
						 	color:'+(_.options.title_color)+' !important;\
						 }';
			}
			if(_.options.title_hover_color!=''){
				cc_css+='.'+(custom_class)+'.yt-defaults-videos-container h3.'+(_.prefix_class)+'-title a:hover,\
						 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-channel-info .'+(_.prefix_class)+'-channel-subs .'+(_.prefix_class)+'-channel-name .'+(_.prefix_class)+'-channel-link:hover,\
						 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-comment-block .'+(_.prefix_class)+'-comment-content .'+(_.prefix_class)+'-comment-entry .'+(_.prefix_class)+'-comment-author .'+(_.prefix_class)+'-channel-link:hover{\
							color:'+(_.options.title_hover_color)+' !important;\
						}';
			}
			if(_.options.text_color!=''){
				cc_css+='.'+(custom_class)+'.yt-defaults-videos-container,\
						 .'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-ready-loaded{\
							color:'+(_.options.text_color)+' !important;\
						}';
			}
			if(_.options.meta_color!=''){
				cc_css+='.'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-metas .'+(_.prefix_class)+'-metas-wrap>*,\
						 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-channel-info .'+(_.prefix_class)+'-channel-metas .'+(_.prefix_class)+'-video-views,\
						 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-publishedAt,\
						 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-comment-block .'+(_.prefix_class)+'-comment-content .'+(_.prefix_class)+'-comment-entry .'+(_.prefix_class)+'-comment-author .'+(_.prefix_class)+'-publishedAt{\
							color:'+(_.options.meta_color)+' !important;\
						}';
			}
			
			if(_.options.header_logo_border_color!=''){
				cc_css+='.'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-header-container .'+(_.prefix_class)+'-header-content .'+(_.prefix_class)+'-header-logo{\
							border-color:'+(_.options.header_logo_border_color)+' !important;\
						}';
			}
			if(_.options.header_channel_name_color!=''){
				cc_css+='.'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-header-container .'+(_.prefix_class)+'-header-content .'+(_.prefix_class)+'-header-body .'+(_.prefix_class)+'-header-title,\
						 .'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-header-container .'+(_.prefix_class)+'-header-content .'+(_.prefix_class)+'-header-body .'+(_.prefix_class)+'-header-title a:not(:hover){\
						 	color:'+(_.options.header_channel_name_color)+' !important;\
						 }';
			}
			if(_.options.header_channel_name_hover_color!=''){
				cc_css+='.'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-header-container .'+(_.prefix_class)+'-header-content .'+(_.prefix_class)+'-header-body .'+(_.prefix_class)+'-header-title a:hover{\
							color:'+(_.options.header_channel_name_hover_color)+' !important;\
						}';
			}
			if(_.options.header_text_color!=''){
				cc_css+='.'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-header-container .'+(_.prefix_class)+'-header-description{\
							color:'+(_.options.header_text_color)+' !important;\
						}';
			}
			if(_.options.header_meta_color!=''){
				cc_css+='.'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-header-container .'+(_.prefix_class)+'-header-background .'+(_.prefix_class)+'-ab-content .'+(_.prefix_class)+'-metas .'+(_.prefix_class)+'-metas-wrap>*{\
							color:'+(_.options.header_meta_color)+' !important;\
						}';
			}
			if(_.options.header_meta_background_color!=''){
				cc_css+='.'+(custom_class)+'.yt-defaults-videos-container .'+(_.prefix_class)+'-header-container .'+(_.prefix_class)+'-header-background .'+(_.prefix_class)+'-ab-content{\
							background-color:'+(_.options.header_meta_background_color)+' !important;\
						}';
			}
			
			if(_.options.popup_background!=''){
				cc_css+='.'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-popup-ads,\
						 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-popup-post{\
							background-color:'+(_.options.popup_background)+' !important;\
						}'
			}
			if(_.options.popup_button_color!=''){
				cc_css+='.'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-pagination-wrap .'+(_.prefix_class)+'-loadmore-btn,\
				 		 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-pagination-wrap .'+(_.prefix_class)+'-next,\
				 		 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-pagination-wrap .'+(_.prefix_class)+'-prev{\
						 	color:'+(_.options.popup_button_color)+' !important;\
						}';
				
				cc_css+='.'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-pagination-wrap .'+(_.prefix_class)+'-loadmore-btn .'+(_.prefix_class)+'-loadmore-dot>span,\
				 		 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-pagination-wrap .'+(_.prefix_class)+'-next .'+(_.prefix_class)+'-loadmore-dot>span,\
				 		 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-pagination-wrap .'+(_.prefix_class)+'-prev .'+(_.prefix_class)+'-loadmore-dot>span{\
						 	background-color:'+(_.options.popup_button_color)+' !important;\
						 }';
			}
			if(_.options.popup_button_background_color!=''){
				cc_css+='.'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-pagination-wrap .'+(_.prefix_class)+'-loadmore-btn:not(:hover),\
				 		 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-pagination-wrap .'+(_.prefix_class)+'-next:not(:hover),\
				 		 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-pagination-wrap .'+(_.prefix_class)+'-prev:not(:hover){\
						 	background-color:'+(_.options.popup_button_background_color)+' !important;\
						 }';
			}
			if(_.options.popup_button_background_hover_color!=''){
				cc_css+='.'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-pagination-wrap .'+(_.prefix_class)+'-loadmore-btn:hover,\
				 		 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-pagination-wrap .'+(_.prefix_class)+'-next:hover,\
				 		 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-pagination-wrap .'+(_.prefix_class)+'-prev:hover,\
						 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-pagination-wrap.'+(_.loading_class)+' .'+(_.prefix_class)+'-loadmore-btn,\
						 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-pagination-wrap.'+(_.loading_class)+' .'+(_.prefix_class)+'-prev,\
						 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-pagination-wrap.'+(_.loading_class)+' .'+(_.prefix_class)+'-next{\
						 	background-color:'+(_.options.popup_button_background_hover_color)+' !important;\
						 }';
			}
			if(_.options.popup_heading_color!=''){
				cc_css+='.'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-video-title,\
						 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-channel-info .'+(_.prefix_class)+'-channel-subs .'+(_.prefix_class)+'-channel-name,\
						 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-channel-info .'+(_.prefix_class)+'-channel-subs .'+(_.prefix_class)+'-channel-name .'+(_.prefix_class)+'-channel-link:not(:hover),\
						 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-comment-block .'+(_.prefix_class)+'-comment-content .'+(_.prefix_class)+'-comment-entry .'+(_.prefix_class)+'-comment-author,\
						 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-comment-block .'+(_.prefix_class)+'-comment-content .'+(_.prefix_class)+'-comment-entry .'+(_.prefix_class)+'-comment-author .'+(_.prefix_class)+'-channel-link:not(:hover){\
						 	color:'+(_.options.popup_heading_color)+' !important;\
						 }';
			}
			if(_.options.popup_heading_hover_color!=''){
				cc_css+='.'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-channel-info .'+(_.prefix_class)+'-channel-subs .'+(_.prefix_class)+'-channel-name .'+(_.prefix_class)+'-channel-link:hover,\
						 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-comment-block .'+(_.prefix_class)+'-comment-content .'+(_.prefix_class)+'-comment-entry .'+(_.prefix_class)+'-comment-author .'+(_.prefix_class)+'-channel-link:hover{\
							color:'+(_.options.popup_heading_hover_color)+' !important;\
						}';
			}
			if(_.options.popup_link_color!=''){
				cc_css+='.'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-popup-description a:not(:hover),\
						 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-comment-block .'+(_.prefix_class)+'-comment-content .'+(_.prefix_class)+'-comment-entry .'+(_.prefix_class)+'-comment-text a:not(:hover){\
						 	color:'+(_.options.popup_link_color)+' !important;\
						 }'
			}
			if(_.options.popup_link_hover_color!=''){
				cc_css+='.'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-popup-description a:hover,\
						 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-comment-block .'+(_.prefix_class)+'-comment-content .'+(_.prefix_class)+'-comment-entry .'+(_.prefix_class)+'-comment-text a:hover{\
						 	color:'+(_.options.popup_link_hover_color)+' !important;\
						 }'
			}
			if(_.options.popup_text_color!=''){
				cc_css+='.'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup{\
							color:'+(_.options.popup_text_color)+' !important;\
						}'
			}
			if(_.options.popup_meta_color!=''){
				cc_css+='.'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-metas .'+(_.prefix_class)+'-metas-wrap>*,\
						 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-channel-info .'+(_.prefix_class)+'-channel-metas .'+(_.prefix_class)+'-video-views,\
						 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-publishedAt,\
						 .'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-comment-block .'+(_.prefix_class)+'-comment-content .'+(_.prefix_class)+'-comment-entry .'+(_.prefix_class)+'-comment-author .'+(_.prefix_class)+'-publishedAt{\
							color:'+(_.options.popup_meta_color)+' !important;\
						}';
			}
			if(_.options.popup_divider_color!=''){
				cc_css+='.'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-top-content{\
							border-bottom-color:'+(_.options.popup_divider_color)+' !important;\
						}';
				cc_css+='.'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-popup-more{\
							border-top-color:'+(_.options.popup_divider_color)+' !important;\
						}';
				cc_css+='.'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-popup-more span{\
							border-color:'+(_.options.popup_divider_color)+' !important;\
						}';
			}			
			/*custom color*/
			
			if(_.options.popup_width!=''){
				cc_css+='.'+(custom_class)+'.yt-defaults-videos-container.'+(_.prefix_class)+'-popup .'+(_.prefix_class)+'-popup-content{\
					max-width:'+(_.options.popup_width)+' !important;\
				}'
			}
			
			if(cc_css!==''){
				var tag = $('<style></style>').attr({
					'type'	: 'text/css',
					'id'	: 'cc_c_'+(custom_class),
				});
				$('head').append(tag);
				$('#cc_c_'+(custom_class)).html(cc_css);
			}
		}
		/*css custom*/
		
		/*create header*/
		ytGallery.prototype.header_create = function(){
			var _ = this;
			
			if(_.options.header && !_.youtube_validate(_.options.header_source)){
				return;
			}
			
			var url_ajax = '';
			
			if(_.options.header_source.indexOf('/user/')!==-1){								
				url_ajax = _.build_url_user(_.youtube_user_parser(_.options.header_source));											
			}else if(_.options.header_source.indexOf('/channel/')!==-1){												
				url_ajax = _.build_url_channel(_.youtube_channel_parser(_.options.header_source));
			}
			
			if(url_ajax===''){
				return;
			}
			
			var header_html = '';
			
			switch(_.options.header_style){
				case 'default':
				
					header_html+='<div class="'+(_.prefix_class)+'-header-container">';
						header_html+='<div class="'+(_.prefix_class)+'-header-background" style="background-image:url({{header_background}})">';
							
							if(_.options.header_videos_counter || _.options.header_subscribers_counter || _.options.header_views_counter){
								header_html+='<div class="'+(_.prefix_class)+'-ab-content '+(_.prefix_class)+'-content-ab-control">';
									header_html+='<div class="'+(_.prefix_class)+'-metas '+(_.prefix_class)+'-metas-bottom '+(_.prefix_class)+'-metas-control">', /*posted-on*/
										header_html+='<div class="'+(_.prefix_class)+'-metas-wrap '+(_.prefix_class)+'-metas-wrap-control">';
											
											if(_.options.header_views_counter){
												header_html+='<div class="'+(_.prefix_class)+'-views-counter '+(_.prefix_class)+'-views-counter-control">\
													<i class="fa fa-eye" aria-hidden="true"></i> <span>{{header_views_counter}}</span>\
												</div>';
											}
											
											if(_.options.header_videos_counter){
												header_html+='<div class="'+(_.prefix_class)+'-videos-counter '+(_.prefix_class)+'-videos-counter-control">\
													<i class="fa fa-video-camera" aria-hidden="true"></i> <span>{{header_videos_counter}}</span>\
												</div>';
											}
											
											if(_.options.header_subscribers_counter){
												header_html+='<div class="'+(_.prefix_class)+'-subscribers-counter '+(_.prefix_class)+'-subscribers-counter-control">\
													<i class="fa fa-users" aria-hidden="true"></i> <span>{{header_subscribers_counter}}</span>\
												</div>';
											}
											
										header_html+='</div>';
									header_html+='</div>';
								header_html+='</div>';	
							}
							
						header_html+='</div>';
						
						if(_.options.header_logo || _.options.header_channel_name || _.options.header_subscribe_button){
						
							header_html+='<div class="'+(_.prefix_class)+'-header-content">';
								
								if(_.options.header_logo){
									header_html+='<div class="'+(_.prefix_class)+'-header-logo">';
										header_html+='<a href="{{channel_link}}" target="_blank"><img src="{{header_logo}}"></a>';
									header_html+='</div>';
								}
								
								if(_.options.header_channel_name || _.options.header_subscribe_button){
									header_html+='<div class="'+(_.prefix_class)+'-header-body">';
										
											header_html+='<h2 class="'+(_.prefix_class)+'-header-title">';
											if(_.options.header_channel_name){
												header_html+='<a href="{{channel_link}}" target="_blank">{{header_channel_name}}</a>';
											}
											header_html+='</h2>';
										
											header_html+='<div class="'+(_.prefix_class)+'-header-subscribe">';
											if(_.options.header_subscribe_button){
												header_html+=	'<script src="https://apis.google.com/js/platform.js"></script>\
																<div class="g-ytsubscribe" data-channelid="{{channel_id}}" data-layout="default" data-count="default"></div>';
											}					
											header_html+='</div>';										
										
									header_html+='</div>';
								}
								
							header_html+='</div>';
						
						}
						
						if(_.options.header_channel_description){
							var noSBClass = '';
							if(!_.options.header_subscribe_button && _.options.header_logo){
								noSBClass = ' '+(_.prefix_class)+'-no-sb-button';
							}else if(_.options.header_subscribe_button && !_.options.header_logo){
								noSBClass = ' '+(_.prefix_class)+'-no-header-logo';
							}else if(!_.options.header_subscribe_button && !_.options.header_logo){
								noSBClass = ' '+(_.prefix_class)+'-no-sb-button-header-logo';
							}
							header_html+='<div class="'+(_.prefix_class)+'-header-description'+(noSBClass)+'">{{header_channel_description}}</div>';
						}
					
					header_html+='</div>';
					
					break;	
			}
			
			$.ajax({
				url: 		url_ajax,
				type: 		'GET',
				cache: 		true,
				dataType: 	'jsonp',
				success: 	function(data){
					
					if(typeof(data.items)==='undefined' || typeof(data.items[0])==='undefined'){
						return;						
					}
					
					if(typeof(_.global_channel_info[data.items[0].id])==='undefined'){
						_.global_channel_info[data.items[0].id] = data.items[0];
					}
					
					var result = {
						header_logo: 				_.options.header_custom_channel_logo!==''?_.options.header_custom_channel_logo:data.items[0].snippet.thumbnails.medium.url,
						header_background: 			_.options.header_custom_channel_background!==''?_.options.header_custom_channel_background:data.items[0].brandingSettings.image.bannerTabletExtraHdImageUrl,						
						header_channel_name: 		_.options.header_custom_channel_name!==''?_.options.header_custom_channel_name:data.items[0].snippet.title,
						header_channel_description: _.options.header_custom_channel_description!==''?_.options.header_custom_channel_description:data.items[0].snippet.description,
						channel_id: 				data.items[0].id,
						channel_link: 				'https://www.youtube.com/channel/'+(data.items[0].id),
						header_views_counter: 		(typeof(data.items[0].statistics)!=='undefined' && typeof(data.items[0].statistics.viewCount)!=='undefined')?_.cFormatter(parseFloat(data.items[0].statistics.viewCount), 1):0,
						header_videos_counter: 		(typeof(data.items[0].statistics)!=='undefined' && typeof(data.items[0].statistics.videoCount)!=='undefined')?_.cFormatter(parseFloat(data.items[0].statistics.videoCount), 1):0,
						header_subscribers_counter: (typeof(data.items[0].statistics)!=='undefined' && typeof(data.items[0].statistics.subscriberCount)!=='undefined')?_.cFormatter(parseFloat(data.items[0].statistics.subscriberCount), 1):0,						
					}
					
					_.$el.prepend(Mustache.render(header_html, result));	
													
				},
				error: 		function(err){
					return;				
				}
			});	
			
		}
		/*create header*/
	
		/*html builder - custom columns*/
		ytGallery.prototype.columns = function(){
			var _ 		= this,
				layout 	= _.options.layout,
				style 	= _.options.style,
				c_class = ' '+(_.prefix_class)+'-'+(layout)+' '+(_.prefix_class)+'-'+(style);
				
			if(layout!=='grid'){
				return c_class;
			}	
			
			if(_.isNumber(_.options.layout_mobile)){
				c_class+=' '+(_.prefix_class)+'-col-'+(_.options.layout_mobile);
			}else{
				c_class+=' '+(_.prefix_class)+'-col-1';
			}
			if(_.isNumber(_.options.layout_portrait_tablet)){
				c_class+=' '+(_.prefix_class)+'-col-pt-'+(_.options.layout_portrait_tablet);
			}
			if(_.isNumber(_.options.layout_landscape_tablet)){
				c_class+=' '+(_.prefix_class)+'-col-lt-'+(_.options.layout_landscape_tablet);
			}
			if(_.isNumber(_.options.layout_small_desktop)){
				c_class+=' '+(_.prefix_class)+'-col-sm-'+(_.options.layout_small_desktop);
			}
			if(_.isNumber(_.options.layout_medium_desktop)){
				c_class+=' '+(_.prefix_class)+'-col-md-'+(_.options.layout_medium_desktop);
			}
			if(_.isNumber(_.options.layout_large_desktop)){
				c_class+=' '+(_.prefix_class)+'-col-lg-'+(_.options.layout_large_desktop);
			}
			if(_.isNumber(_.options.layout_extra_large_desktop)){
				c_class+=' '+(_.prefix_class)+'-col-el-'+(_.options.layout_extra_large_desktop);
			}
			
			return c_class;
		}/*html builder - custom columns*/	
		
		/*html builder - tab control*/
		ytGallery.prototype.tab_control = function(){
			var _ = this;
			$('.'+(_.prefix_class)+'-tab-section-control', _.$el).off('.tabControlGroup').on('click.tabControlGroup', function(){
				var $t 			= $(this),
				$parent 		= $t.parents('.'+(_.prefix_class)+'-tab-group-control'),
				index 			= $t.attr('data-index');
				
				if(typeof(index)!=='undefined' && _.isNumber(index)){
					$('span.'+(_.prefix_class)+'-player-close-control, .'+(_.prefix_class)+'-popup-close-control').trigger('click');
					$('.'+(_.prefix_class)+'-tab-section-control', $parent).removeClass(_.active_class);
					$t.addClass(_.active_class);
					$('.'+(_.prefix_class)+'-listing-section-control', _.$el).removeClass(_.active_class);
					_.$el_section[index].addClass(_.active_class);
					_.group_active = Number(index);
					
					if(_.options.layout==='carousel' && _.isNumber(_.options.carousel_config.autoplay)){
						$.each(_.$el_carousel, function(i, value){
							_.$el_carousel[i].stopAutoplay();
						});
					}
					
					if(typeof(_.global_first_setup[Number(index)])==='undefined'){
						_.get_data_source(Number(index));
					}else{
						
						if(_.options.layout==='carousel' && typeof(_.$el_carousel[index])!=='undefined'){
							if(_.isNumber(_.options.carousel_config.autoplay) && !_.$el_carousel[index].autoplaying){
								_.$el_carousel[index].startAutoplay();
							}
						}
												
					}
				}
			});
		}/*html builder - tab control*/
		
		/*loading bar*/
		ytGallery.prototype.loading_bar = function(index, percent){
			var _ 			= this,
				$loadbar 	= $('.'+(_.prefix_class)+'-loading-bar-percent', _.$el_loadbar[index]);
				
			if($loadbar.attr('style')==='width: 100%;' || $loadbar.attr('style')==='width: 100%' || $loadbar.attr('style')==='width:100%;' || $loadbar.attr('style')==='width:100%'){
				return;
			}
			
			$loadbar.css({width:percent});
			if(percent==='100%'){
				setTimeout(function(){
					_.$el_loadbar[index].addClass(_.hidden_class);
				},300);	
			}
		}/*loading bar*/
		
		/*check number*/
		ytGallery.prototype.isNumber = function(n){
			var _ = this;
			return !isNaN(parseFloat(n)) && isFinite(n);
		}/*check number*/
	/*html builder: 1*/
	
	/*data control: 2 - check channel data vs playlists*/
	ytGallery.prototype.get_data_source = function(index){
		
		var _ 			= this;
		
		if(_.options.debug){
			console.log('Setup: 2 - before');
		}		
		
		var	data		= _.data_group;
			
		if(typeof(data[index])!=='object'){
			return;
		}
		
		var data_obj = 	data[index];
		
		if(data_obj.users_length>0 || data_obj.channels_length>0){
			_.get_users_channels(index);
		}else{
			_.build_data(index, _.sorting_playlists(index, data_obj.playlists), true);
		}
		
		_.global_first_setup[index] = true;
		
		if(_.options.debug){
			console.log('Setup: 2 - after');
		}
		
		_.loading_bar(index, '18%');
	}/*data control: 2*/
	
	/*data control: 3 - get playlist id by user vs playlist id by channel*/
	ytGallery.prototype.get_users_channels = function(index){
		
		var _ 				= this;
		
		if(_.options.debug){
			console.log('Setup: 3 - before');
		}		
		
		var	data			= _.data_group,
			data_obj 		= data[index],
			request_length 	= data_obj.users_length+data_obj.channels_length,
			playlists 		= [];
			
		_.global_user_channel_length[index] = 0;	
		
		$.each(data_obj.users_urls, function(i, value){			
			$.ajax({
				url: 		value['url'],
				type: 		'GET',
				cache: 		true,
				dataType: 	'jsonp',
				success: 	function(data){
					if(_.api_error(index, data) && typeof(data.items[0])!=='undefined'){						
						$.ajax({
							url: 		_.build_url_channel(data.items[0].id),
							type: 		'GET',
							cache: 		true,
							dataType: 	'jsonp',
							success: 	function(data){
								if(typeof(data.items[0])!=='undefined'){						
									playlists.push({id:data.items[0].contentDetails.relatedPlaylists.uploads, sort_index:value['sort_index']});
									_.global_channel_info[data.items[0].id] = data.items[0];
								}
								_.merge_playlists(index, request_length, playlists, data_obj);															
							},
							error: 		function(err){
								_.merge_playlists(index, request_length, playlists, data_obj);								
							}
						});
					}else{
						_.merge_playlists(index, request_length, playlists, data_obj);	
					}
				},
				error: 		function(err){
					_.merge_playlists(index, request_length, playlists, data_obj);					
				}
			});
		});
		
		$.each(data_obj.channels_urls, function(i, value){			
			$.ajax({
				url: 		value['url'],
				type: 		'GET',
				cache: 		true,
				dataType: 	'jsonp',
				success: 	function(data){
					if(_.api_error(index, data) && typeof(data.items[0])!=='undefined'){						
						playlists.push({id:data.items[0].contentDetails.relatedPlaylists.uploads, sort_index:value['sort_index']});	
						_.global_channel_info[data.items[0].id] = data.items[0];					
					}	
					_.merge_playlists(index, request_length, playlists, data_obj);								
				},
				error: 		function(err){
					_.merge_playlists(index, request_length, playlists, data_obj);					
				}
			});
		});
		
		if(_.options.debug){
			console.log('Setup: 3 - after');
		}
	}/*data control: 3*/	
	
	/*data control: 4 - return all playlist IDs*/
	ytGallery.prototype.merge_playlists = function(index, request_length, playlists, data_obj){
		var _ = this;
		
		if(_.options.debug){
			console.log('Setup: 4 - before');
		}		
		
		_.global_user_channel_length[index]++;
		if(_.global_user_channel_length[index]===request_length){
			if(Array.isArray(data_obj.playlists)){
				$.merge(playlists, data_obj.playlists);
			}
					
			_.build_data(index, _.sorting_playlists(index, playlists), true);
			
			_.loading_bar(index, '28%');
		}
		
		if(_.options.debug){
			console.log('Setup: 4 - after');
		}
	}/*data control: 4*/
	
	/*data control: 5 - sorting playlist*/
	ytGallery.prototype.sorting_playlists = function(index, playlists){
		var _ 				= this;
		
		if(_.options.debug){
			console.log('Setup: 5 - before');
		}
		
		
		var	fn_playlists 	= [];
		
		$.each(playlists, function(i, value){
			var p_item = value;			
			if(typeof(p_item)!=='undefined'){
				fn_playlists[p_item.sort_index] = p_item.id;
			}
		});	
		
		var result = $.grep(fn_playlists,function(n){ 
			return n == 0 || n;
		});
		
		_.loading_bar(index, '53%');
		
		if(_.options.debug){
			console.log('Setup: 5 - after');
		}
		
		if(result.length>0){
			return result;
		}
		
		return null;			
	}/*data control: 5*/
	
	/*data control: 6 - get all video IDs*/
	ytGallery.prototype.build_data = function(index, playlists, first_load){
		var  _ 			= this;
		if(_.options.debug){
			console.log('Setup: 6 - before');
		}		
		
		var	data		= _.data_group;
			
		if(!Array.isArray(playlists)){
			playlists = [];
		}else{
			playlists = $.grep(playlists,function(n){ 
				return n == 0 || n;
			});
		}
		
		var data_obj 			= data[index],
			request_length 		= playlists.length,
			first_rq_length 	= 0,
			video_ids 			= [],
			array_index 		= 1;
			
		_.global_playlists[index] = [];	
				
		if(request_length>0){
			if(first_load){
				video_ids[0]=data_obj.videos;
			}else{
				if(!Array.isArray(_.global_last_page_items[index])){
					array_index = 0;
				}else{
					if(_.global_last_page_items[index].length>0){						
						array_index = 1;
						video_ids[0] =_.global_last_page_items[index].map(function(a){							
							return a.id
						});						
					}
				}
			}					
			$.each(playlists, function(i, value){
				if(typeof(value)==='undefined'){
					first_rq_length++;	
					if(request_length===first_rq_length){							
						_.build_items(index, video_ids);				
						_.loading_bar(index, '68%');							
					}
					return;
				}
				
				var value_id,
					url_playlist;
				
				if(typeof(value)==='object' && typeof(value.id)!=='undefined' && typeof(value.next)!=='undefined'){
					value_id = value.id;
					url_playlist = _.build_url_playlist(value_id, value.next);
				}else{					
					value_id = value;
					url_playlist = _.build_url_playlist(value_id, '');
				}
				
				$.ajax({
					url: 		url_playlist,
					type: 		'GET',
					cache: 		true,
					dataType: 	'jsonp',
					success: 	function(data){											
						if(_.api_error(index, data) && typeof(data.items)!=='undefined'){
							var items = data.items;
							var video_ids_array = items.map(function(a){
								return a.contentDetails.videoId
							});
														
							video_ids[i+array_index]=video_ids_array;
							if(typeof(data.nextPageToken)!=='undefined'){
								_.global_playlists[index][i] = {id:value_id, next:data.nextPageToken};
							}
						}
						first_rq_length++;	
						if(request_length===first_rq_length){																			
							_.build_items(index, video_ids);				
							_.loading_bar(index, '68%');							
						}					
					},
					error: 		function(err){
						first_rq_length++;	
						if(request_length===first_rq_length){
							_.build_items(index, video_ids);
							_.loading_bar(index, '68%');
						}		
					}
				});
				
			});
		}else{
			if(first_load){
				_.build_items(index, data_obj.videos);
				_.loading_bar(index, '86%');
			}else{
				_._pagination_control(index);
			}			
		}	
		
		if(_.options.debug){
			console.log('Setup: 6 - after');
		}
	}
		/*build url playlist*/
		ytGallery.prototype.build_url_playlist = function(id, pageToken){
			var _ = 		this,
				pt_string = '';
			
			if(typeof(pageToken)!=='undefined' && pageToken!==''){
				pt_string='&pageToken='+pageToken;
			}
			return (_.options.api)+'playlistItems?playlistId='+id+'&part=contentDetails&maxResults='+(_.options.layout_items_per_page)+'&key='+(_.options.api_key)+(pt_string);
		}/*build url playlist*/
	/*data control: 6*/
	
	/*data control: 7 - build url request by Video IDs*/
	ytGallery.prototype.build_items = function(index, video_ids){
		
		var _ = this;
		
		if(_.options.debug){
			console.log('Setup: 7 - before');
		}		
		
		if(!Array.isArray(video_ids)){
			_._pagination_control(index);		
			return;
		}
					
		var	items		= [],
			run_paged 	= 0,
			video_query = $.grep([].concat.apply([], video_ids),function(n){ 
				return n == 0 || n;
			});
				
		var video_length = video_query.length,
			video_paged = Math.floor(video_length/50);
		if(video_length%50 > 0){
			video_paged++;
		}
		
		if(video_paged===0){
			_._pagination_control(index);
			return;
		}
		
		var video_ids_paged = [];
		
		for(var i=0;i<video_paged;i++){
			if(i===video_paged-1){
				video_ids_paged[i] = video_query.slice(i*50, video_length);
			}else{
				video_ids_paged[i] = video_query.slice(i*50, 50*(i+1));
			}	
		}
		
		$.each(video_ids_paged, function(i, value){
			$.ajax({
				url: 		_.build_url_video(value),
				type: 		'GET',
				cache: 		true,
				dataType: 	'jsonp',
				success: 	function(data){
					if(!_.api_error(index, data)){
						return;
					}
					
					if(typeof(data.items)!=='undefined'){					
						items[i] = data.items;	
					}
					run_paged++;					
					if(typeof(_.$el_list[index])==='object' && run_paged===video_paged){
						_.global_items[index] = $.grep([].concat.apply([], items),function(n){ 
							return n == 0 || n;
						});
						_.loading_bar(index, '86%');
						_.build_page_data(index, 1);												
					}				
				},
				error: 		function(err){
					run_paged++;
					if(typeof(_.$el_list[index])==='object' && run_paged===video_paged){
						_.global_items[index] = $.grep([].concat.apply([], items),function(n){ 
							return n == 0 || n;
						});
						_.loading_bar(index, '86%');
						_.build_page_data(index, 1);						
					}															
				}
			});
		});	
		
		if(_.options.debug){
			console.log('Setup: 7 - after');	
		}
	}
	
		/*build url videos*/
		ytGallery.prototype.build_url_video = function(id){
			var _ = this;
			return (_.options.api)+'videos?id='+id+'&part=snippet,contentDetails,statistics&key='+(_.options.api_key);
		}/*build url videos*/		
	/*data control: 7*/
	
	/*data control: 8 - create paged for layout*/
	ytGallery.prototype.build_page_data = function(index, paged){
		
		var _ = this;
		
		if(_.options.debug){
			console.log('Setup: 8 - before');
		}		
		
		var	items 					= _.global_items[index],
			items_length 			= items.length,
			html 					= '',
			layout 					= _.options.layout,			
			layout_items_per_page 	= _.options.layout_items_per_page,
			layout_pagination		= _.options.layout_pagination,	
			layout_play_mode		= _.options.layout_play_mode,					
			pagination_html 		= '',
			global_playlists		= [];
					
		if(items_length===0){
			_._pagination_control(index);
			return;
		}
		
		if(Array.isArray(_.global_playlists[index]) && _.global_playlists[index].length>0){
			global_playlists = $.grep(_.global_playlists[index],function(n){ 
				return n == 0 || n;
			});
		}
		
		_.global_current_page[index] = paged;	
		
		if(paged===1){	
			_.global_total_pages[index] = Math.floor(items_length/layout_items_per_page);
			if(items_length%layout_items_per_page > 0){
				_.global_total_pages[index]++;
			}			
			if(typeof(_.$el_pagination_wrap[index])==='undefined' || _.$el_pagination_wrap[index].length===0){	
				if((global_playlists.length>0 || _.global_total_pages[index]>1) && layout!=='carousel'){			
					switch(layout_pagination){
						case 'loadmore':
							pagination_html+=	'<div class="'+(_.prefix_class)+'-pagination-wrap '+(_.prefix_class)+'-pagination-wrap-control '+(_.prefix_class)+'-padding-top-bottom">\
													<div class="'+(_.prefix_class)+'-loadmore-btn '+(_.prefix_class)+'-loadmore-control">\
														<span class="'+(_.prefix_class)+'-loadmore-text">'+(_.options.text_load_more)+'</span>\
														<span class="'+(_.prefix_class)+'-loadmore-dot">\
															<span></span>\
															<span></span>\
															<span></span>\
														</span>\
													</div>\
												</div>';
							_.$el_section[index].append(pagination_html);
							_.$el_pagination_wrap[index] = $('.'+(_.prefix_class)+'-pagination-wrap-control', _.$el_section[index]);
							_.loadmore_control(index);					
							break;
							
						case 'infinite':
							pagination_html+=	'<div class="'+(_.prefix_class)+'-pagination-wrap '+(_.prefix_class)+'-pagination-wrap-control">\
													<div class="'+(_.prefix_class)+'-infinite '+(_.prefix_class)+'-infinite-control">\
														<div class="'+(_.prefix_class)+'-load-icon"></div>\
													</div>\
												</div>';
							_.$el_section[index].append(pagination_html);
							_.$el_pagination_wrap[index] = $('.'+(_.prefix_class)+'-pagination-wrap-control', _.$el_section[index]);					
							_.infinite_control(index);					
							break;
							
						case 'prev-next':
							pagination_html+=	'<div class="'+(_.prefix_class)+'-pagination-wrap '+(_.prefix_class)+'-pagination-wrap-control '+(_.prefix_class)+'-padding-top-bottom">\
													<div class="'+(_.prefix_class)+'-prev-next '+(_.prefix_class)+'-prev-next-control">\
														<span class="'+(_.prefix_class)+'-prev '+(_.prefix_class)+'-prev-control '+(_.hidden_class)+'">\
															<i class="fa fa-angle-double-left" aria-hidden="true"></i>'+(_.options.text_prev)+'\
														</span>\
														<span class="'+(_.prefix_class)+'-next '+(_.prefix_class)+'-next-control">\
															'+(_.options.text_next)+'<i class="fa fa-angle-double-right" aria-hidden="true"></i>\
															<span class="'+(_.prefix_class)+'-loadmore-dot">\
																<span></span>\
																<span></span>\
																<span></span>\
															</span>\
														</span>\
													</div>\
												</div>';
							_.$el_section[index].append(pagination_html);
							_.$el_pagination_wrap[index] = $('.'+(_.prefix_class)+'-pagination-wrap-control', _.$el_section[index]);
							_.next_control(index);	
							_.prev_control(index);				
							break;	
					}
				}
				
				if(layout==='carousel'){
					pagination_html+=	'<div class="'+(_.prefix_class)+'-pagination-wrap '+(_.prefix_class)+'-cr-style '+(_.prefix_class)+'-pagination-wrap-control">\
											<div class="'+(_.prefix_class)+'-prev-next '+(_.prefix_class)+'-prev-next-control">\
												<span class="'+(_.prefix_class)+'-prev '+(_.prefix_class)+'-prev-control '+(_.hidden_class)+'">\
													<span class="'+(_.prefix_class)+'-loadmore-dot">\
														<span></span>\
														<span></span>\
														<span></span>\
													</span>\
													<i class="fa fa-angle-left" aria-hidden="true"></i>\
													<span class="'+(_.prefix_class)+'-loadmore-dot">\
														<span></span>\
														<span></span>\
														<span></span>\
													</span>\
												</span>\
												<span class="'+(_.prefix_class)+'-next '+(_.prefix_class)+'-next-control">\
													<span class="'+(_.prefix_class)+'-loadmore-dot">\
														<span></span>\
														<span></span>\
														<span></span>\
													</span>\
													<i class="fa fa-angle-right" aria-hidden="true"></i>\
													<span class="'+(_.prefix_class)+'-loadmore-dot">\
														<span></span>\
														<span></span>\
														<span></span>\
													</span>\
												</span>\
											</div>\
										</div>';
										
					_.$el_section[index].append(pagination_html);
					_.$el_pagination_wrap[index] = $('.'+(_.prefix_class)+'-pagination-wrap-control', _.$el_section[index]);
					_.create_slide(index);
				}
			}
			_.loading_bar(index, '100%');
		}else if(paged>=_.global_total_pages[index]){
			if(global_playlists.length>0){
				_.global_last_page_items[index] = items.slice(layout_items_per_page*(paged-1), items_length);		
				_.build_data(index, global_playlists, false);
				return;
			}else{
				_._pagination_control(index);
			}
		}
		
		html = _.build_item_html(items.slice(layout_items_per_page*(paged-1), layout_items_per_page*paged));
		
		
		if(html===''){
			_.global_all_data_loaded[index] = true;
		}else{			
			if(layout_pagination==='prev-next'){			
				$('.'+(_.prefix_class)+'-page-items-control', _.$el_section[index]).removeClass(_.active_class);
				_.$el_list[index].append('<div class="'+(_.prefix_class)+'-page-items '+(_.prefix_class)+'-page-items-control '+(_.active_class)+'">'+(html)+'</div>');
				if(_.$el_list[index].find('.'+(_.prefix_class)+'-page-items-control').length>1){
					_._scroll_top();
				}				
			}else if(layout==='carousel'){
								
				_.$el_carousel[index].appendSlide(html);
				_.carousel_resize[index] = 0;
				
				if(_.isNumber(_.options.carousel_config.autoplay) && !_.$el_carousel[index].autoplaying){
					if(
						_.mouse_events.x>=_.$el_section[index].offset().left 
						&& _.mouse_events.x<=(_.$el_section[index].offset().left+_.$el_section[index].outerWidth()) 
						&& _.mouse_events.y>=_.$el_section[index].offset().top
						&& _.mouse_events.y<=(_.$el_section[index].offset().top+_.$el_section[index].outerHeight())
					){
						//_.$el_carousel[index].stopAutoplay();
					}else{
						_.$el_carousel[index].startAutoplay();
					}
				}
				
				if(_.$el_carousel[index].isBeginning && _.$el_carousel[index].isEnd){
					_.build_page_data(index, _.global_current_page[index]+1);
				}	
				
				if(global_playlists.length===0 && _.global_items[index].length===0){				
					_._pagination_control(index);
				}
				
				if(_.$el_carousel[index].isEnd && typeof(_.global_all_data_loaded[index])!=='undefined' && _.global_all_data_loaded[index]===true){
					$('.'+(_.prefix_class)+'-next-control', _.$el_section[index]).addClass(_.hidden_class);
				}else{
					$('.'+(_.prefix_class)+'-next-control', _.$el_section[index]).removeClass(_.hidden_class);
				}
																				
			}else{
				_.$el_list[index].append(html);
			}
						
			if(layout_play_mode==='popup'){
				_.play_mode_popup();				
			}else if(layout_play_mode==='inline'){
				_.play_mode_inline();
			}
		}
		
		if(typeof(_.$el_pagination_wrap[index])==='undefined'){
			return;
		}
		
		_.$el_pagination_wrap[index].removeClass(_.loading_class);
		
		if(_.options.debug){
			console.log('Setup: 8 - after');
		}
		
	}
		/*pagination - loadmore*/
		ytGallery.prototype.loadmore_control = function(index){
			var _ = this;
			$('.'+(_.prefix_class)+'-loadmore-control', _.$el_section[index]).off('.loadmoreControl').on('click.loadmoreControl', function(){
				var $t 			= $(this);
				
				if(typeof(_.global_all_data_loaded[index])!=='undefined' && _.global_all_data_loaded[index]===true){
					return;
				}
				
				_.$el_pagination_wrap[index].addClass(_.loading_class);		
				_.build_page_data(index, _.global_current_page[index]+1);
			});
		}/*pagination - loadmore*/
		
		/*pagination - prev*/
		ytGallery.prototype.prev_control = function(index){
			var _ = this;
			$('.'+(_.prefix_class)+'-prev-control', _.$el_section[index]).off('.prevControl').on('click.prevControl', function(){
				var $t = $(this),
					$page_active = $('.'+(_.prefix_class)+'-page-items-control.'+(_.active_class), _.$el_list[index]);
				
				$t.next('.'+(_.prefix_class)+'-next-control').removeClass(_.hidden_class);
				
				if($page_active.prev('.'+(_.prefix_class)+'-page-items-control').length===0){
					return;
				}else{
					$page_active.removeClass(_.active_class);
					$page_active.prev('.'+(_.prefix_class)+'-page-items-control').addClass(_.active_class);
					if($page_active.prev('.'+(_.prefix_class)+'-page-items-control').prev('.'+(_.prefix_class)+'-page-items-control').length===0){
						$t.addClass(_.hidden_class);
					}
					_._scroll_top();
				}			
			});
		}/*pagination - prev*/
		
		/*pagination - next*/
		ytGallery.prototype.next_control = function(index){
			var _ = this;
			$('.'+(_.prefix_class)+'-next-control', _.$el_section[index]).off('.nextControl').on('click.nextControl', function(){
				var $t = $(this);
				
				$t.prev('.'+(_.prefix_class)+'-prev-control').removeClass(_.hidden_class);
				var $page_active = $('.'+(_.prefix_class)+'-page-items-control.'+(_.active_class), _.$el_list[index]);
				
				if(typeof(_.global_all_data_loaded[index])!=='undefined' && _.global_all_data_loaded[index]===true){	
					
					if($page_active.next('.'+(_.prefix_class)+'-page-items-control').length===0){
						return;
					}else{
						$page_active.removeClass(_.active_class);
						$page_active.next('.'+(_.prefix_class)+'-page-items-control').addClass(_.active_class);
						if($page_active.next('.'+(_.prefix_class)+'-page-items-control').next('.'+(_.prefix_class)+'-page-items-control').length===0){
							$t.addClass(_.hidden_class);
						}
						_._scroll_top();
					}			
					return;
					
				}else if($page_active.next('.'+(_.prefix_class)+'-page-items-control').length>0){
					
					$page_active.removeClass(_.active_class);
					$page_active.next('.'+(_.prefix_class)+'-page-items-control').addClass(_.active_class);					
					_._scroll_top();				
					return;	
									
				}
				
				_.$el_pagination_wrap[index].addClass(_.loading_class);		
				_.build_page_data(index, _.global_current_page[index]+1);
			});
		}/*pagination - next*/
		
		/*scrolltop for prev-next page*/
		ytGallery.prototype._scroll_top = function(){
			var _ = this;
			window.scrollTo(0, _.$el.offset().top-$('#wpadminbar').height()-30);
		}/*scrolltop for prev-next page*/
		
		/*pagination - infinite scroll*/
		ytGallery.prototype.infinite_control = function(index){
			var _ = this;
			$(window).on('scroll', function(){
				var $t = $(this);			
									
				if(_.group_active!==index || _.$el_pagination_wrap[index].hasClass(_.loading_class) || _.$el_pagination_wrap[index].hasClass(_.stop_load_data_class)){				
					return;
				}				
				
				var	ajaxVisible = _.$el_pagination_wrap[index].offset().top,
					ajaxScrollTop = $t.scrollTop()+$t.height();
					
				if(ajaxVisible <= (ajaxScrollTop) && (ajaxVisible + $(window).height()) > ajaxScrollTop){				
					_.$el_pagination_wrap[index].addClass(_.loading_class);				
					_.build_page_data(index, _.global_current_page[index]+1);
				}			
			});
		}/*pagination - infinite scroll*/
		
		/*create carousel slider*/
		ytGallery.prototype.create_slide = function(index){
			var	_ 				= this,
				carousel_config	= _.options.carousel_config;
			
			var css_transition = 	'<style type="text/css" id="cssts-'+(_.global_custom_class)+'">\
										.'+(_.global_custom_class)+' .'+(_.prefix_class)+'-carousel-wrapper-control{\
											transition-duration:'+(carousel_config.speed)+'ms !important;\
											-webkit-transition-duration:'+(carousel_config.speed)+'ms !important;\
									}</style>';
			
			carousel_config['onInit'] = function(slide){						
				_.slide_prev_control(index);
				_.slide_next_control(index);
				_.slide_resize(index);
				
				if(!_.isNumber(carousel_config.autoplay)){
					return;							
				}
				
				if($('#cssts-'+(_.global_custom_class)).length===0){
					$('head').append(css_transition);
				}
					
				_.$el_section[index].on('mouseenter', function(){
					slide.stopAutoplay();
				}).on('mouseleave', function(){
					slide.startAutoplay();
				});
			}
			
			carousel_config['onTouchStart'] = function(){
				if(!_.isNumber(carousel_config.autoplay)){
					return;
				}
				$('#cssts-'+(_.global_custom_class)).remove();
			}
			
			carousel_config['onTouchEnd'] = function(){
				if(!_.isNumber(carousel_config.autoplay)){
					return;
				}
				$('head').append(css_transition);
			}
						
			_.$el_carousel[index] = _.$el_list[index].find('.'+(_.prefix_class)+'-carousel-container-control').swiper(carousel_config);	
			
			_.$el_carousel[index].on('slideChangeStart', function(slide){
				
				if(slide.autoplaying && !_.$el_section[index].hasClass(_.active_class)){
					slide.stopAutoplay();
				}
				
				if(slide.isEnd && typeof(_.global_all_data_loaded[index])==='undefined'){							
					_.$el_pagination_wrap[index].addClass(_.loading_class);
					_.build_page_data(index, _.global_current_page[index]+1);
				}
										
				if(slide.isBeginning){
					$('.'+(_.prefix_class)+'-prev-control', _.$el_section[index]).addClass(_.hidden_class);
				}else{
					$('.'+(_.prefix_class)+'-prev-control', _.$el_section[index]).removeClass(_.hidden_class);
				}
				
				if(slide.isEnd && typeof(_.global_all_data_loaded[index])!=='undefined' && _.global_all_data_loaded[index]===true){
					$('.'+(_.prefix_class)+'-next-control', _.$el_section[index]).addClass(_.hidden_class);
				}else{
					$('.'+(_.prefix_class)+'-next-control', _.$el_section[index]).removeClass(_.hidden_class);
				}
				
				if(!slide.params.autoplayStopOnLast){
					return;
				}
				
				if(slide.isEnd && typeof(_.global_all_data_loaded[index])!=='undefined' && _.global_all_data_loaded[index]===true){
					slide.params.autoplayStopOnLast = false;
					slide.update();
				}								
										
			});
		}/*create carousel slider*/
		
		/*pagination - slide prev*/
		ytGallery.prototype.slide_prev_control = function(index){
			var _ = this;
			$('.'+(_.prefix_class)+'-prev-control', _.$el_section[index]).off('.prevControl').on('click.prevControl', function(){
				var $t = $(this);
				_.$el_carousel[index].slidePrev();					
			});			
		}/*pagination - slide prev*/
		
		/*pagination - slide next*/
		ytGallery.prototype.slide_next_control = function(index){
			var _ = this;
			$('.'+(_.prefix_class)+'-next-control', _.$el_section[index]).off('.nextControl').on('click.nextControl', function(){
				var $t 					= $(this);
				_.$el_carousel[index].slideNext();
			});			
		}/*pagination - slide next*/
		
		/*carousel resize*/
		ytGallery.prototype.slide_resize = function(index){
			var _ 				= this,
				default_width 	= window.innerWidth;
				
			$(window).on('resize', function(){
				if(default_width === window.innerWidth){
					return;
				}
				
				setTimeout(function(){					
					if(_.$el_carousel[index].isBeginning){
						$('.'+(_.prefix_class)+'-prev-control', _.$el_section[index]).addClass(_.hidden_class);
					}else{
						$('.'+(_.prefix_class)+'-prev-control', _.$el_section[index]).removeClass(_.hidden_class);
					}
					
					if(_.$el_carousel[index].isEnd && typeof(_.global_all_data_loaded[index])!=='undefined' && _.global_all_data_loaded[index]===true){
						$('.'+(_.prefix_class)+'-next-control', _.$el_section[index]).addClass(_.hidden_class);
					}else{
						$('.'+(_.prefix_class)+'-next-control', _.$el_section[index]).removeClass(_.hidden_class);
					}
				},200);				
												
				if((typeof(_.carousel_resize[index])==='undefined' || _.carousel_resize[index]!==1) && _.$el_carousel[index].isEnd){
					_.carousel_resize[index] = 1;
					_.build_page_data(index, _.global_current_page[index]+1);
				}
				
				default_width 	= window.innerWidth;
			});	
		}/*carousel resize*/
		
		/*hide pagination - if no data*/
		ytGallery.prototype._pagination_control = function(index){
			var _ 					= this,
				layout 				= _.options.layout,				
				layout_pagination	= _.options.layout_pagination;		
			
			_.global_all_data_loaded[index] = true;
			
			if(typeof(_.$el_pagination_wrap[index])==='undefined'){
				return;
			}
			
			_.$el_pagination_wrap[index].addClass(_.stop_load_data_class);		
				
			if(layout_pagination==='prev-next'){
				
				var $page_active = $('.'+(_.prefix_class)+'-page-items-control.'+(_.active_class), _.$el_list[index]);
				if($page_active.next('.'+(_.prefix_class)+'-page-items-control').length>0){
					$page_active.removeClass(_.active_class);
					$page_active.next('.'+(_.prefix_class)+'-page-items-control').addClass(_.active_class);
					if($page_active.next('.'+(_.prefix_class)+'-page-items-control').next('.'+(_.prefix_class)+'-page-items-control').length===0){
						$('.'+(_.prefix_class)+'-next-control', _.$el_pagination_wrap[index]).addClass(_.hidden_class);					
					}
					_.$el_pagination_wrap[index].removeClass(_.loading_class);
					_._scroll_top();				
					return;
				}
				
				$('.'+(_.prefix_class)+'-next-control', _.$el_pagination_wrap[index]).addClass(_.hidden_class);
				_.$el_pagination_wrap[index].removeClass(_.loading_class);
				
			}else{
				if(layout==='carousel'){					
					if(_.$el_carousel[index].isEnd){
						$('.'+(_.prefix_class)+'-next-control', _.$el_pagination_wrap[index]).addClass(_.hidden_class);
						_.$el_pagination_wrap[index].removeClass(_.loading_class);
					}
					return;
				}else{
					_.$el_pagination_wrap[index].addClass(_.hidden_class);
				}
			}	
			
			_.$el_pagination_wrap[index].after('<div class="'+(_.prefix_class)+'-ready-loaded">'+(_.options.text_already_loaded)+'</div>');
			
			if(layout_pagination==='prev-next'){
				setTimeout(function(){
					$('.'+(_.prefix_class)+'-ready-loaded', _.$el_section[index]).hide('slow');
				},1500);
			}
		}/*hide pagination - if no data*/
		
		/*check mobile system*/
		ytGallery.prototype.getMobileOperatingSystem = function(){
			return navigator.userAgent.match(/(Android|iPod|iPhone|iPad|IEMobile|Opera Mini)/);
		}/*check mobile system*/
		
		/*play mode popup*/
		ytGallery.prototype.play_mode_popup = function(){
			var _ 								= this,
				player_autoplay					= _.options.player_autoplay,
				text_views						= _.options.text_views,
				text_show_more					= _.options.text_show_more,
				text_show_less					= _.options.text_show_less,
				text_published_at				= _.options.text_published_at,
				text_load_ads					= _.options.text_load_ads,
				text_skip_ad_in					= _.options.text_skip_ad_in,
				text_skip_ads					= _.options.text_skip_ads,				
				popup_title						= _.options.popup_title,
				popup_channel_logo				= _.options.popup_channel_logo,
				popup_channel_name				= _.options.popup_channel_name,
				popup_subscribe_button			= _.options.popup_subscribe_button,
				popup_views_counter				= _.options.popup_views_counter,
				popup_likes_counter				= _.options.popup_likes_counter,
				popup_dislikes_counter			= _.options.popup_dislikes_counter,
				popup_likes_ratio				= _.options.popup_likes_ratio,
				popup_date						= _.options.popup_date,
				popup_description				= _.options.popup_description,
				popup_description_more_button	= _.options.popup_description_more_button,
				popup_comments					= _.options.popup_comments,
				popup_share						= _.options.popup_share;
				
			$('.'+(_.prefix_class)+'-open-video-control', _.$el).off('.openVideoDetails').on('click.openVideoDetails', function(){
				var $t				= $(this),
					video_id 		= $t.attr('data-id'),
					video_duration 	= $t.attr('data-duration');
					
				if(typeof(video_id)==='undefined' || video_id===''){						
					return false;
				}
				
				$('span.'+(_.prefix_class)+'-player-close-control, .'+(_.prefix_class)+'-popup-close-control').trigger('click');
				
				var frame_id = ((_.global_custom_class)+(video_id)).toString();	
				
				if($('#'+(frame_id)).length>0){
					$('#'+(frame_id)).removeClass(_.hidden_class);
					_.popup_ads(frame_id);
					
					if(typeof(_.global_video_player[(frame_id)].playVideo)!=='function'){
						return false;
					}
					if(player_autoplay){
						if(typeof(_.global_video_current_time[(frame_id)])!=='undefined' && _.global_video_current_time[(frame_id)]>0){
							_.global_video_player[(frame_id)].seekTo(_.global_video_current_time[(frame_id)], true);
						}
						_.global_video_player[(frame_id)].playVideo();
					}else{
						if(typeof(_.global_video_current_time[(frame_id)])!=='undefined' && _.global_video_current_time[(frame_id)]>0){
							_.global_video_player[(frame_id)].seekTo(_.global_video_current_time[(frame_id)], false);
						}
						_.global_video_player[(frame_id)].pauseVideo();
					}					
					return false;
				}
				
				var popupShareHTML 	= '';
				var videoURL 		= encodeURI('https://youtu.be/'+(video_id));
				var onclick			= '';
				
				if(popup_share.show){
					
					popupShareHTML +='<div class="'+(_.prefix_class)+'-social-share">';
					
					if(typeof(popup_share.facebook)!=='undefined' && popup_share.facebook){
						onclick 		= "window.open('https://www.facebook.com/sharer/sharer.php?u="+(videoURL)+"','facebook-share-dialog','width=600,height=400');return false;";
						popupShareHTML +='<div class="'+(_.prefix_class)+'-share-item '+(_.prefix_class)+'-facebook">';
						popupShareHTML +=	'<a href="javascript:;" target="_blank" rel="nofollow" onclick="'+(onclick)+'">';
						popupShareHTML +=		'<i class="fa fa-facebook"></i>';
						popupShareHTML +=	'</a>';
						popupShareHTML +='</div>';	
					}
					
					if(typeof(popup_share.twitter)!=='undefined' && popup_share.twitter){
						onclick 		="window.open('http://twitter.com/share?text=&amp;url="+(videoURL)+"','twitter-share-dialog','width=600,height=400');return false;";
						popupShareHTML +='<div class="'+(_.prefix_class)+'-share-item '+(_.prefix_class)+'-twitter">';
						popupShareHTML +=	'<a href="javascript:;" target="_blank" rel="nofollow" onclick="'+(onclick)+'">';
						popupShareHTML +=		'<i class="fa fa-twitter"></i>';
						popupShareHTML +=	'</a>';
						popupShareHTML +='</div>';
					}
					
					if(typeof(popup_share.google)!=='undefined' && popup_share.google){
						onclick 		="window.open('https://plus.google.com/share?url="+(videoURL)+"','googleplus-share-dialog','width=600,height=400');return false;";
						popupShareHTML +='<div class="'+(_.prefix_class)+'-share-item '+(_.prefix_class)+'-google">';
						popupShareHTML +=	'<a href="javascript:;" target="_blank" rel="nofollow" onclick="'+(onclick)+'">';
						popupShareHTML +=		'<i class="fa fa-google-plus"></i>';
						popupShareHTML +=	'</a>';
						popupShareHTML +='</div>';
					}
					
					if(typeof(popup_share.linkedIn)!=='undefined' && popup_share.linkedIn){
						onclick 		= "window.open('http://www.linkedin.com/shareArticle?mini=true&amp;url="+(videoURL)+"&amp;title=&amp;source=','linkedin-share-dialog','width=600,height=400');return false;";
						popupShareHTML +='<div class="'+(_.prefix_class)+'-share-item '+(_.prefix_class)+'-linkedin">';
						popupShareHTML +=	'<a href="javascript:;" target="_blank" rel="nofollow" onclick="'+(onclick)+'">';
						popupShareHTML +=		'<i class="fa fa-linkedin"></i>';
						popupShareHTML +=	'</a>';
						popupShareHTML +='</div>';
					}
					
					if(typeof(popup_share.tumblr)!=='undefined' && popup_share.tumblr){
						onclick 		="window.open('http://www.tumblr.com/share/link?url="+(videoURL)+"&amp;name=','tumblr-share-dialog','width=600,height=400');return false;";
						popupShareHTML +='<div class="'+(_.prefix_class)+'-share-item '+(_.prefix_class)+'-tumblr">';
						popupShareHTML +=	'<a href="javascript:;" target="_blank" rel="nofollow" onclick="'+(onclick)+'">';
						popupShareHTML +=		'<i class="fa fa-tumblr"></i>';
						popupShareHTML +=	'</a>';
						popupShareHTML +='</div>';
					}
					
					if(typeof(popup_share.pinterest)!=='undefined' && popup_share.pinterest){
						onclick 		="window.open('//pinterest.com/pin/create/button/?url="+(videoURL)+"&amp;media=&amp;description=','pin-share-dialog','width=600,height=400');return false;";
						popupShareHTML +='<div class="'+(_.prefix_class)+'-share-item '+(_.prefix_class)+'-pinterest">';
						popupShareHTML +=	'<a href="javascript:;" target="_blank" rel="nofollow" onclick="'+(onclick)+'">';
						popupShareHTML +=		'<i class="fa fa-pinterest"></i>';
						popupShareHTML +=	'</a>';
						popupShareHTML +='</div>';
					}
					
					if(typeof(popup_share.vk)!=='undefined' && popup_share.vk){
						onclick 		="window.open('//vkontakte.ru/share.php?url="+(videoURL)+"','vk-share-dialog','width=600,height=400');return false;";
						popupShareHTML +='<div class="'+(_.prefix_class)+'-share-item '+(_.prefix_class)+'-vk">';
						popupShareHTML +=	'<a href="javascript:;" target="_blank" rel="nofollow" onclick="'+(onclick)+'">';
						popupShareHTML +=		'<i class="fa fa-vk"></i>';
						popupShareHTML +=	'</a>';
						popupShareHTML +='</div>';
					}
					
					if(typeof(popup_share.email)!=='undefined' && popup_share.email){
						onclick 		= "mailto:?subject=&amp;body="+(videoURL)+"";
						popupShareHTML +='<div class="'+(_.prefix_class)+'-share-item '+(_.prefix_class)+'-email">';
						popupShareHTML +=	'<a href="'+(onclick)+'">';
						popupShareHTML +=		'<i class="fa fa-envelope"></i>';
						popupShareHTML +=	'</a>';
						popupShareHTML +='</div>';
					}
					
					popupShareHTML +='</div>';
				}
				
				$('body').append(
					'<div id="'+(frame_id)+'" class="yt-defaults-videos-container '+(_.global_custom_class)+' '+(_.prefix_class)+'-popup '+(_.prefix_class)+'-popup-control">\
						<div class="'+(_.prefix_class)+'-popup-scroll '+(_.prefix_class)+'-popup-scroll-control">\
							<div class="'+(_.prefix_class)+'-popup-content '+(_.prefix_class)+'-popup-content-control">\
								<div class="'+(_.prefix_class)+'-popup-overlay '+(_.prefix_class)+'-popup-close-control"></div>\
								<div class="'+(_.prefix_class)+'-popup-player '+(_.prefix_class)+'-popup-player-control">\
									<div class="'+(_.prefix_class)+'-load-icon"></div>\
									<div class="'+(_.prefix_class)+'-player-iframe '+(_.prefix_class)+'-player-iframe-control">\
										<div id="popup-'+(frame_id)+'"></div>\
										<div class="'+(_.prefix_class)+'-video-ads '+(_.prefix_class)+'-video-ads-control">\
											<span class="'+(_.prefix_class)+'-text-load-ads '+(_.prefix_class)+'-text-load-ads-control">'+(text_load_ads)+'</span>\
											<span class="'+(_.prefix_class)+'-close-load-ads '+(_.prefix_class)+'-close-load-ads-control"></span>\
											<div class="'+(_.prefix_class)+'-video-ads-content '+(_.prefix_class)+'-video-ads-content-control"></div>\
											<span class="'+(_.prefix_class)+'-skip-ads '+(_.prefix_class)+'-skip-ads-control">\
												<span class="'+(_.prefix_class)+'-skip-text '+(_.prefix_class)+'-skip-text-control">'+(text_skip_ads)+'\
												<i class="fa fa-angle-right" aria-hidden="true"></i><i class="fa fa-angle-right" aria-hidden="true"></i><i class="fa fa-angle-right" aria-hidden="true"></i>\
												</span>\
												<span class="'+(_.prefix_class)+'-skip-seconds">\
													<span>'+(text_skip_ad_in)+'</span>\
													<span class="'+(_.prefix_class)+'-skip-seconds-style '+(_.prefix_class)+'-skip-seconds-control"></span>\
												</span>\
												<span class="'+(_.prefix_class)+'-skip-image '+(_.prefix_class)+'-skip-image-control">\
													<img src="'+($('.'+(_.prefix_class)+'-pic-link-control[data-id="'+video_id+'"]', _.$el).attr('data-img'))+'">\
												</span>\
											</span>\
											<span class="'+(_.prefix_class)+'-skip-ads-sub '+(_.prefix_class)+'-skip-ads-control"></span>\
										</div>\
										'+(popupShareHTML)+'\
									</div>\
								</div>\
								<div class="'+(_.prefix_class)+'-popup-ads '+(_.prefix_class)+'-popup-ads-control">\
									<div class="'+(_.prefix_class)+'-popup-ads-content '+(_.prefix_class)+'-popup-ads-content-control"></div>\
								</div>\
								<div class="'+(_.prefix_class)+'-popup-post '+(_.prefix_class)+'-popup-post-control">\
									<div class="'+(_.prefix_class)+'-load-icon"></div>\
								</div>\
							</div>\
						</div>\
						<span class="'+(_.prefix_class)+'-popup-close '+(_.prefix_class)+'-button-control-style '+(_.prefix_class)+'-popup-close-control"><span></span></span>\
					</div>'
				);
				
				var $post = $('.'+(_.prefix_class)+'-popup-post-control', $('#'+(frame_id)));				
				var $close = $('.'+(_.prefix_class)+'-popup-close-control', $('#'+(frame_id)));
				var $player =$('.'+(_.prefix_class)+'-popup-player-control', $('#'+(frame_id)));
				
				_.popup_ads(frame_id);
				
				$close.off('.closePopupVideo').on('click.closePopupVideo', function(){
					$('#'+(frame_id)).addClass(_.hidden_class);
					
					$player.find('.'+(_.prefix_class)+'-skip-ads-control').trigger('click');
					$('#'+(frame_id))
					.find('.'+(_.prefix_class)+'-popup-ads-control').removeClass(_.active_class)
					.find('.'+(_.prefix_class)+'-popup-ads-content-control').html('');
					
					if(typeof(_.global_video_player[(frame_id)].getCurrentTime)==='function'){
						if(_.global_video_player[(frame_id)].getCurrentTime()>0){
							_.global_video_current_time[(frame_id)] = _.global_video_player[(frame_id)].getCurrentTime();
						}
						_.global_video_player[(frame_id)].stopVideo();
					}					
				});	
				
				$(document).keydown(function(e) {
					/*ESCAPE key pressed*/
					if(e.keyCode == 27){
						$('#'+(frame_id)).addClass(_.hidden_class);
						
						$player.find('.'+(_.prefix_class)+'-skip-ads-control').trigger('click');
						$('#'+(frame_id))
						.find('.'+(_.prefix_class)+'-popup-ads-control').removeClass(_.active_class)
						.find('.'+(_.prefix_class)+'-popup-ads-content-control').html('');
						
						if(typeof(_.global_video_player[(frame_id)].getCurrentTime)==='function'){
							if(_.global_video_player[(frame_id)].getCurrentTime()>0){
								_.global_video_current_time[(frame_id)] = _.global_video_player[(frame_id)].getCurrentTime();
							}
							_.global_video_player[(frame_id)].stopVideo();	
						}											
					}
				});
				
				_.global_video_player[(frame_id)] = new YT.Player('popup-'+(frame_id), {						
					videoId: 		video_id,
					playerVars: 	{
										enablejsapi:	1, 
										html5:			1, 
										wmode:			'transparent', 
										modestbranding:	1, 
										iv_load_policy:	3,
										autoplay:		0,
										playsinline:	1,
										rel:			0,
									},
					events: 		{
										'onReady': function(event){	
											$('#popup-'+(frame_id)).attr({'wmode':'Opaque'});										
											_.first_create_vid(video_id, frame_id, $player, player_autoplay);
										},
										'onStateChange':function(event){
											if(event.data===0){
												event.target.stopVideo();
												_.global_video_current_time[(frame_id)] = 0;
											}
											_.video_ads(video_id, frame_id, video_duration, $player);
										}
									},				
				});
								
				$.ajax({
					url: 		_.build_url_video(video_id),
					type: 		'GET',
					cache: 		true,
					dataType: 	'jsonp',
					success: 	function(data){
						if(typeof(data.items[0])==='undefined'){
							return;
						}						
						
						var value = data.items[0];
						
						var result = {
							id:						value.id,
							channel_id:				value.snippet.channelId,
							img:					_.img_src_set(value.snippet.thumbnails, value.snippet.title),
							title: 					value.snippet.title,
							description:			_.yt_description(value.snippet.description, false, true),
							duration: 				_.YTDurationToSeconds(value.contentDetails.duration),
							date: 					moment(value.snippet.publishedAt).format('MMMM Do YYYY, h:mm:ss A'),//new Date().setTime(Date.parse(value.snippet.publishedAt)),
							
							views_counter: 			(typeof(value.statistics)!=='undefined' && typeof(value.statistics.viewCount)!=='undefined')?_.nFormatter(parseFloat(value.statistics.viewCount), 1):0,
							likes_counter: 			(typeof(value.statistics)!=='undefined' && typeof(value.statistics.likeCount)!=='undefined')?_.nFormatter(parseFloat(value.statistics.likeCount), 1):0,
							dislikes_counter: 		(typeof(value.statistics)!=='undefined' && typeof(value.statistics.dislikeCount)!=='undefined')?_.nFormatter(parseFloat(value.statistics.dislikeCount), 1):0,				
							comments_counter: 		(typeof(value.statistics)!=='undefined' && typeof(value.statistics.commentCount)!=='undefined')?_.nFormatter(parseFloat(value.statistics.commentCount), 1):0,
							
							views_counter_c: 		(typeof(value.statistics)!=='undefined' && typeof(value.statistics.viewCount)!=='undefined')?_.cFormatter(parseFloat(value.statistics.viewCount), 1):0,
							likes_counter_c: 		(typeof(value.statistics)!=='undefined' && typeof(value.statistics.likeCount)!=='undefined')?_.cFormatter(parseFloat(value.statistics.likeCount), 1):0,
							dislikes_counter_c: 	(typeof(value.statistics)!=='undefined' && typeof(value.statistics.dislikeCount)!=='undefined')?_.cFormatter(parseFloat(value.statistics.dislikeCount), 1):0,				
							comments_counter_c: 	(typeof(value.statistics)!=='undefined' && typeof(value.statistics.commentCount)!=='undefined')?_.cFormatter(parseFloat(value.statistics.commentCount), 1):0,
							
							channel_link:			'https://www.youtube.com/channel/'+(value.snippet.channelId),
							like_bar_percent:		(typeof(value.statistics)!=='undefined' && typeof(value.statistics.likeCount)!=='undefined' && typeof(value.statistics.dislikeCount)!=='undefined')?(parseFloat(value.statistics.likeCount)/(parseFloat(value.statistics.likeCount)+parseFloat(value.statistics.dislikeCount))*100):0,
						}
												
						var content_template = '';
						
						if(popup_title || popup_channel_logo || popup_channel_name || popup_subscribe_button || popup_views_counter || popup_likes_counter || popup_dislikes_counter || popup_likes_ratio){
						
							content_template+='<div class="'+(_.prefix_class)+'-top-content">';
							
								if(popup_title){
									content_template+='<h1 class="'+(_.prefix_class)+'-video-title">{{title}}</h1>';
								}
								
								content_template+='<div class="'+(_.prefix_class)+'-channel-info">';
									
									if(popup_channel_logo){
										content_template+='<div class="'+(_.prefix_class)+'-channel-brand">';
											content_template+='<a href="{{channel_link}}" target="_blank" title="{{channel_name}}" class="'+(_.prefix_class)+'-channel-link">';
												content_template+='<img class="'+(_.prefix_class)+'-channel-logo" alt="{{channel_name}}" src="{{channel_logo}}">';									
											content_template+='</a>';
										content_template+='</div>';
									}
									
									if(popup_channel_name || popup_subscribe_button){
										content_template+='<div class="'+(_.prefix_class)+'-channel-subs">';
										
											if(popup_channel_name){
												content_template+='<h2 class="'+(_.prefix_class)+'-channel-name">';
													content_template+='<a href="{{channel_link}}" target="_blank" title="{{channel_name}}" class="'+(_.prefix_class)+'-channel-link">';
														content_template+='{{channel_name}}';
													content_template+='</a>';
												content_template+='</h2>';
											}
											
											if(popup_subscribe_button){		
												content_template+='<div class="'+(_.prefix_class)+'-channel-subs-btn">';
													content_template+='<script src="https://apis.google.com/js/platform.js"></script>';
													content_template+='<div class="g-ytsubscribe" data-channelid="'+(result.channel_id)+'" data-layout="default" data-count="default"></div>';
												content_template+='</div>';
											}
											
										content_template+='</div>';
									}								
									
									if(popup_views_counter || popup_likes_counter || popup_dislikes_counter || popup_likes_ratio){
										content_template+='<div class="'+(_.prefix_class)+'-channel-metas">';
										
											if(popup_views_counter){
												content_template+='<div class="'+(_.prefix_class)+'-video-views">{{views_counter_c}} '+(text_views)+'</div>';
											}
											
											if(popup_likes_ratio){
												content_template+='<div class="'+(_.prefix_class)+'-like-bar"><span style="width:{{like_bar_percent}}%"></span></div>';
											}
											
											if(popup_likes_counter || popup_dislikes_counter){
												content_template+='<div class="'+(_.prefix_class)+'-like-dislike-count">';
												
													content_template+='<div class="'+(_.prefix_class)+'-metas '+(_.prefix_class)+'-metas-bottom '+(_.prefix_class)+'-metas-control">',
														content_template+='<div class="'+(_.prefix_class)+'-metas-wrap '+(_.prefix_class)+'-metas-wrap-control">';
																										
															if(popup_likes_counter){
																content_template+='<div class="'+(_.prefix_class)+'-likes '+(_.prefix_class)+'-likes-control">\
																	<i class="fa fa-thumbs-up" aria-hidden="true"></i> <span>{{likes_counter_c}}</span>\
																</div>';
															}
															
															if(popup_dislikes_counter){
																content_template+='<div class="'+(_.prefix_class)+'-dislikes '+(_.prefix_class)+'-dislikes-control">\
																	<i class="fa fa-thumbs-down" aria-hidden="true"></i> <span>{{dislikes_counter_c}}</span>\
																</div>';
															}
															
														content_template+='</div>';
													content_template+='</div>';
													
												content_template+='</div>';
											}
										content_template+='</div>';
									}
									
								content_template+='</div>';
								
							content_template+='</div>';
							
						}
						
						if(popup_date){
							content_template+='<div class="'+(_.prefix_class)+'-publishedAt">'+(text_published_at)+': {{date}}</div>';
						}
						
						if(popup_description && result.description!==''){
							
							var description_class = '';
							
							if(popup_description_more_button){
								description_class = (_.prefix_class)+'-description-more '+(_.hidden_class);
							}
							
							content_template+='<div class="'+(_.prefix_class)+'-popup-description '+(_.prefix_class)+'-description-control '+(description_class)+'">';
								content_template+='{{{description}}}';								
							content_template+='</div>';
							
							if(popup_description_more_button){
								content_template+='<div class="'+(_.prefix_class)+'-popup-more '+(_.prefix_class)+'-more-control"><span>'+(text_show_more)+'</span></div>';
							}
						}
						
						if(popup_comments){
							content_template+='<div class="'+(_.prefix_class)+'-comment-block '+(_.prefix_class)+'-comment-block-control">';
							content_template+='</div>';
						}
						
						$post.off('.showMoreEvent').on('click.showMoreEvent', '.'+(_.prefix_class)+'-more-control', function(){
							var $t = $(this),
								$t_c = $post.find('.'+(_.prefix_class)+'-description-control');
							$t_c.toggleClass(_.hidden_class);
							if($t_c.hasClass(_.hidden_class)){
								$t.find('span').text(text_show_more);
							}else{
								$t.find('span').text(text_show_less);
							}							
						});
												
						if(typeof(_.global_channel_info[result.channel_id])==='undefined'){
							$.ajax({
								url: 		_.build_url_channel(result.channel_id),
								type: 		'GET',
								cache: 		true,
								dataType: 	'jsonp',
								success: 	function(data){
									if(typeof(data.items[0])==='undefined'){
										post.find('.'+(_.prefix_class)+'-load-icon').remove();						
										return;				
									}
									
									result['channel_logo'] = data.items[0].snippet.thumbnails.default.url;
									result['channel_name'] = data.items[0].snippet.title;
									
									$post
									.prepend(Mustache.render(content_template, result))
									.find('.'+(_.prefix_class)+'-excerpt-control').linkify({
										target: '_blank',
									});
																		
									if(popup_comments){
										_.build_comment(result.id, $post, '');	
									}else{
										$post.find('.'+(_.prefix_class)+'-load-icon').remove();
									}
								},
								error: 		function(err){
													
								}
							});
						}else{
							result['channel_logo'] = _.global_channel_info[result.channel_id].snippet.thumbnails.default.url;
							result['channel_name'] = _.global_channel_info[result.channel_id].snippet.title;							
							
							$post
							.prepend(Mustache.render(content_template, result))
							.find('.'+(_.prefix_class)+'-excerpt-control').linkify({
								target: '_blank',
							});
							
							if(popup_comments){
								_.build_comment(result.id, $post, '');	
							}else{
								$post.find('.'+(_.prefix_class)+'-load-icon').remove();
							}
						}						
					},
					error: 		function(err){
																			
					}
				});
						
				return false;
			});	
		}
			/*comment builder*/
			ytGallery.prototype.build_comment = function(video_id, post, pageToken){
				var _ 						= this,
					text_view_all_replies	= _.options.text_view_all_replies;
				$.ajax({
					url: 		_.build_url_comment(video_id, pageToken),
					type: 		'GET',
					cache: 		true,
					dataType: 	'jsonp',
					success: 	function(data){
						if(typeof(data.items)==='undefined'){	
							post.find('.'+(_.prefix_class)+'-load-icon').remove();					
							return;				
						}
						
						var comment_template = '';					
						comment_template+='<div class="'+(_.prefix_class)+'-comment-item '+(_.prefix_class)+'-comment-item-control">';
							comment_template+='<div class="'+(_.prefix_class)+'-comment-content '+(_.prefix_class)+'-comment-content-control">';
								comment_template+='<div class="'+(_.prefix_class)+'-comment-img '+(_.prefix_class)+'-comment-img-control">';
									comment_template+='<a href="{{authorChannelUrl}}" target="_blank" title="{{authorDisplayName}}" class="'+(_.prefix_class)+'-channel-link">';
										comment_template+='<img class="'+(_.prefix_class)+'-channel-logo" alt="{{authorDisplayName}}" src="{{authorProfileImageUrl}}">';									
									comment_template+='</a>';
								comment_template+='</div>';
								comment_template+='<div class="'+(_.prefix_class)+'-comment-entry '+(_.prefix_class)+'-comment-entry-control">';
									comment_template+='<h3 class="'+(_.prefix_class)+'-comment-author '+(_.prefix_class)+'-comment-author-control">';
										comment_template+='<a href="{{authorChannelUrl}}" target="_blank" title="{{authorDisplayName}}" class="'+(_.prefix_class)+'-channel-link">';
											comment_template+='{{authorDisplayName}}';
										comment_template+='</a>';
										comment_template+='<span class="'+(_.prefix_class)+'-publishedAt '+(_.prefix_class)+'-publishedAt-control">{{publishedAt}}</span>';
									comment_template+='</h3>';
									comment_template+='<div class="'+(_.prefix_class)+'-comment-text '+(_.prefix_class)+'-comment-text-control">{{{textDisplay}}}</div>';
								comment_template+='</div>';
							comment_template+='</div>';	
						comment_template+='</div>';	
						
						var html = '';
						$.each(data.items, function(i, value){
							var result = {
								id:						value.id,
								publishedAt:			moment(value.snippet.topLevelComment.snippet.publishedAt).fromNow(),							
								textDisplay:			value.snippet.topLevelComment.snippet.textDisplay,
								authorDisplayName: 		value.snippet.topLevelComment.snippet.authorDisplayName,				
								authorProfileImageUrl: 	value.snippet.topLevelComment.snippet.authorProfileImageUrl,							
								authorChannelUrl:		value.snippet.topLevelComment.snippet.authorChannelUrl,							
							}
							
							html+=Mustache.render(comment_template, result);
							
							if(typeof(value.replies)!=='undefined'  && typeof(value.replies.comments)!=='undefined' && value.replies.comments.length>0){
								var comment_reply_class = '';
								if(value.replies.comments.length>2){
									comment_reply_class = _.hidden_class;
								}
								html+='<div id="c'+(result.id)+'" class="'+(_.prefix_class)+'-comment-reply '+(_.prefix_class)+'-comment-reply-control '+(comment_reply_class)+'">';
									$.each(value.replies.comments, function(i, value){
										var reply = {
											publishedAt:			moment(value.snippet.publishedAt).fromNow(),							
											textDisplay:			value.snippet.textDisplay,
											authorDisplayName: 		value.snippet.authorDisplayName,				
											authorProfileImageUrl: 	value.snippet.authorProfileImageUrl,							
											authorChannelUrl:		value.snippet.authorChannelUrl,							
										}
										html+=Mustache.render(comment_template, reply);
									});
								html+='</div>';
								
								if(value.replies.comments.length>2){
									html+='<div class="'+(_.prefix_class)+'-comment-reply-showmore" data-id="#c'+(result.id)+'">';
										html+='<span class="'+(_.prefix_class)+'-comment-reply-showmore-control" data-id="#c'+(result.id)+'">';
											html+=text_view_all_replies;
										html+='</span>';								
									html+='</div>';									
								}
							}
						});						
						
						post.find('.'+(_.prefix_class)+'-load-icon').remove();
						post.find('.'+(_.prefix_class)+'-comment-block-control').append(html);
						post.find('.'+(_.prefix_class)+'-pagination_comment-wrap-control').removeClass(_.loading_class);
												
						if(post.find('.'+(_.prefix_class)+'-comment-reply-showmore-control').length>0){
							post.off('.actionShowReplyComments').on('click.actionShowReplyComments', '.'+(_.prefix_class)+'-comment-reply-showmore-control', function(){							
								var $t = $(this),
									control_id = $t.attr('data-id');
								$(control_id).toggleClass(_.hidden_class);
								$t.remove();
							});		
						}
						
						var comment_pagination = '';						
						if(typeof(data.nextPageToken)!=='undefined' && post.find('.'+(_.prefix_class)+'-pagination_comment-wrap-control').length===0){
							comment_pagination+='<div class="'+(_.prefix_class)+'-pagination-wrap '+(_.prefix_class)+'-pagination_comment-wrap-control">\
													<div class="'+(_.prefix_class)+'-loadmore-btn '+(_.prefix_class)+'-loadmore_comment-control">\
														<span class="'+(_.prefix_class)+'-loadmore-text">'+(_.options.text_load_more)+'</span>\
														<span class="'+(_.prefix_class)+'-loadmore-dot">\
															<span></span>\
															<span></span>\
															<span></span>\
														</span>\
													</div>\
												</div>';
							post.append(comment_pagination);
									
						}else if(typeof(data.nextPageToken)==='undefined' && post.find('.'+(_.prefix_class)+'-pagination_comment-wrap-control').length>0){
							post.find('.'+(_.prefix_class)+'-pagination_comment-wrap-control').addClass(_.hidden_class);
							return;
						}
						
						post.off('.actionNextPageComments').on('click.actionNextPageComments', '.'+(_.prefix_class)+'-loadmore_comment-control', function(){							
							var $t 		= $(this),
								$parent = $t.parents('.'+(_.prefix_class)+'-pagination_comment-wrap-control');
							$parent.addClass(_.loading_class);	
							_.build_comment(video_id, post, data.nextPageToken);								
						});							
					},
					error: 		function(err){
						post.find('.'+(_.prefix_class)+'-load-icon').remove();					
					}
				});
			}/*comment builder*/
		/*play mode popup*/		
		
		/*play mode inline*/
		ytGallery.prototype.play_mode_inline = function(){
			var _ 						= this,
				player_autoplay			= _.options.player_autoplay,
				player_inline_close		= _.options.player_inline_close,
				player_inline_light		= _.options.player_inline_light;
			
			$('.'+(_.prefix_class)+'-open-video-control', _.$el).off('.openVideoDetails').on('click.openVideoDetails', function(){
				var $t				= $(this),
					video_id 		= $t.attr('data-id'),
					video_duration 	= $t.attr('data-duration'),
					$parent_frame 	= $t.parents('.'+(_.prefix_class)+'-item-control').find('.'+(_.prefix_class)+'-picture-wrap-control');
				
				if(typeof(video_id)==='undefined' || video_id===''){						
					return false;
				}
							
				$('span.'+(_.prefix_class)+'-player-close-control').trigger('click');
				$parent_frame.addClass(_.active_class);	
				
				var frame_id = ((_.global_custom_class)+(video_id)).toString();
				
				if($parent_frame.hasClass((_.prefix_class)+'-player-setup')){
					$parent_frame.find('.'+(_.prefix_class)+'-player-control').removeClass(_.hidden_class);
					if(typeof(_.global_video_player[(frame_id)].playVideo)!=='function'){
						return false;
					}
					if(player_autoplay){
						if(typeof(_.global_video_current_time[(frame_id)])!=='undefined' && _.global_video_current_time[(frame_id)]>0){
							_.global_video_player[(frame_id)].seekTo(_.global_video_current_time[(frame_id)], false);
						}
						_.global_video_player[(frame_id)].playVideo();
					}else{
						if(typeof(_.global_video_current_time[(frame_id)])!=='undefined' && _.global_video_current_time[(frame_id)]>0){
							_.global_video_player[(frame_id)].seekTo(_.global_video_current_time[(frame_id)], false);
						}
						_.global_video_player[(frame_id)].pauseVideo();
					}						
					return false;
				}
				
				$parent_frame.addClass((_.prefix_class)+'-player-setup');
				
				var elm_close = '',
					elm_light = '';
					
				if(player_inline_close){
					elm_close = '<span class="'+(_.prefix_class)+'-player-close '+(_.prefix_class)+'-button-control-style '+(_.prefix_class)+'-player-close-control"><span></span></span>';
				}else{
					elm_close = '<span class="'+(_.prefix_class)+'-player-close-control"></span>';
				}	
				
				if(player_inline_light){
					elm_light = '<span class="'+(_.prefix_class)+'-player-light '+(_.prefix_class)+'-button-control-style '+(_.prefix_class)+'-player-light-control">\
									<i class="fa fa-lightbulb-o" aria-hidden="true"></i>\
								</span>';
				}
				
				$parent_frame.append(
					'<div class="'+(_.prefix_class)+'-player '+(_.prefix_class)+'-player-control">\
						<div class="'+(_.prefix_class)+'-load-icon"></div>\
						<div class="'+(_.prefix_class)+'-player-overlay '+(_.prefix_class)+'-player-light-control"></div>\
						<div class="'+(_.prefix_class)+'-player-iframe '+(_.prefix_class)+'-player-iframe-control">\
							<div id="'+(frame_id)+'"></div>\
						</div>\
						'+(elm_close)+'\
						'+(elm_light)+'\
					</div>'
				);
				
				var $player = $parent_frame.find('.'+(_.prefix_class)+'-player-control');
				
				if(player_inline_light){
					var $light = $('.'+(_.prefix_class)+'-player-light-control', $parent_frame);
					$light.off('.lightInlineVideo').on('click.lightInlineVideo', function(){
						var $t = $(this);
						
						if($player.hasClass((_.prefix_class)+'-light-setup') || $player.hasClass((_.prefix_class)+'-light-open')){
							$player.removeClass((_.prefix_class)+'-light-setup '+(_.prefix_class)+'-light-open');
							return;
						}
						
						var offset_left = $player.offset().left,
							offset_top = $player.offset().top - $(window).scrollTop(),
							width = $player.width(),
							height = $player.height();
							
						var css = {
							left:offset_left+'px',
							top:offset_top+'px',
							width:(width)+'px',
							height:(height)+'px',
						}
						
						$player												
						.css(css)
						.addClass((_.prefix_class)+'-light-setup')
						.find('.'+(_.prefix_class)+'-player-iframe-control')
						.css(css);
						
						setTimeout(function(){
							$player
							.removeAttr('style')
							.addClass((_.prefix_class)+'-light-open')
							.find('.'+(_.prefix_class)+'-player-iframe-control')
							.removeAttr('style');														
						},66);	
																
					});
				}												
				
				var $close = $('.'+(_.prefix_class)+'-player-close-control', $parent_frame);
				$close.off('.closeInlineVideo').on('click.closeInlineVideo', function(){
					$player
					.addClass(_.hidden_class)
					.removeClass((_.prefix_class)+'-light-setup '+(_.prefix_class)+'-light-open');
					
					$parent_frame.removeClass(_.active_class);
					
					if(typeof(_.global_video_player[(frame_id)].stopVideo)==='function'){
						if(_.global_video_player[(frame_id)].getCurrentTime()>0){
							_.global_video_current_time[(frame_id)] = _.global_video_player[(frame_id)].getCurrentTime();
						}						
						_.global_video_player[(frame_id)].stopVideo();
					}
				});
				
				_.global_video_player[(frame_id)] = new YT.Player((frame_id), {						
					videoId: 		video_id,
					playerVars: 	{
										enablejsapi:	1, 
										html5:			1, 
										wmode:			'transparent', 
										modestbranding:	1, 
										iv_load_policy:	3,
										autoplay:		0,
										playsinline:	1,										
										rel:			0,
									},
					events: 		{
										'onReady': function(event){
											$player.addClass((_.prefix_class)+'-player-loaded');
											if($parent_frame.hasClass(_.active_class) && player_autoplay && !_.getMobileOperatingSystem()){
												_.global_video_player[(frame_id)].playVideo();
											};																						
										},
										'onStateChange':function(event){
											if(event.data===0){
												event.target.stopVideo();
												_.global_video_current_time[(frame_id)] = 0;												
											}
										}
									},				
				});
				
				return false;
			});
		}/*play mode inline*/
		
		/*google ads setup*/
		ytGallery.prototype.setGoogleAds = function(){
			var _ = this;					
			$('.adsbygoogle:not([data-adsbygoogle-status="done"])').each(function(){
				(adsbygoogle = window.adsbygoogle || []).push({});
			 });
		}/*google ads setup*/
		
		/*popup ads*/
		ytGallery.prototype.popup_ads = function(frame_id){
			var _ 						= this,
				enabled 				= _.options.popup_ads.enabled,
				ad_type					= _.options.popup_ads.ad_type,
				google_ads_client_id 	= _.options.popup_ads.google_ads_client_id,
				google_ads_slot_id 		= _.options.popup_ads.google_ads_slot_id,
				ad_image 				= _.options.popup_ads.ad_image,				
				adsContent 				= '';
				
			if(!enabled){
				return;
			}
			
			if(ad_type==='ga' && google_ads_client_id!=='' || google_ads_slot_id!==''){
				adsContent = 	'<ins class="adsbygoogle" style="display:block" data-ad-client="'+(google_ads_client_id)+'" data-ad-slot="'+(google_ads_slot_id)+'" data-ad-format="auto"></ins>';
			}
			
			if(ad_type==='img' && Array.isArray(ad_image) && ad_image.length>0){
				
				var objectRand = ad_image[Math.floor(Math.random() * ad_image.length)],
					img_source = objectRand.img,
					img_link = objectRand.link_target;
					
				if(typeof(img_source)==='undefined' || img_source===''){
					return;
				}	
				
				$('#'+(frame_id)).find('.'+(_.prefix_class)+'-popup-ads-content-control').addClass((_.prefix_class)+'-type-img-ad');			
					
				if(typeof(img_link)!=='undefined' && img_link!==''){
					adsContent+='<a href="'+(img_link)+'" target="_blank">';
				}
					adsContent+='<img class="'+(_.prefix_class)+'-img-ads-control" src="'+(img_source)+'">';
					
				if(typeof(img_link)!=='undefined' && img_link!==''){
					adsContent+='</a>';
				}	
			}
			
			if(adsContent===''){
				return;
			}
								
			$('#'+(frame_id))
			.find('.'+(_.prefix_class)+'-popup-ads-control').addClass(_.active_class)
			.find('.'+(_.prefix_class)+'-popup-ads-content-control').html(adsContent);	
			
			if(ad_type==='ga'){
				_.setGoogleAds();	
			}
		}/*popup ads*/
		
		/*video ads*/
		ytGallery.prototype.first_create_vid = function(video_id, frame_id, player, player_autoplay){
			var _ 						= this,
				enabled 				= _.options.player_video_ads.enabled,
				ad_type					= _.options.player_video_ads.ad_type,				
				ad_video 				= _.options.player_video_ads.ad_video;
				
				if(enabled){
					var adsContent = '';
					
					if(ad_type==='vid' && Array.isArray(ad_video) && ad_video.length>0){
					
						var objectRand = ad_video[Math.floor(Math.random() * ad_video.length)],
							mp4 = objectRand.mp4,
							webm = objectRand.webm,
							ogv = objectRand.ogv,
							link_target = objectRand.link_target;	
							
						if((typeof(mp4)==='undefined' || mp4==='') && (typeof(webm)==='undefined' || webm==='') && (typeof(ogv)==='undefined' || ogv==='')){
							return;
						}
						
						player.find('.'+(_.prefix_class)+'-text-load-ads-control').addClass((_.prefix_class)+'-vid-ads-zindex');
						player.find('.'+(_.prefix_class)+'-video-ads-content-control').addClass((_.prefix_class)+'-type-vid-ad');
						
						var video_source = '';
						
						if(typeof(mp4)!=='undefined' && mp4!==''){
							video_source+='<source src="'+(mp4)+'" type="video/mp4">';
						}
						if(typeof(webm)!=='undefined' && webm!==''){
							video_source+='<source src="'+(webm)+'" type="video/webm">';
						}
						if(typeof(ogv)!=='undefined' && ogv!==''){
							video_source+='<source src="'+(ogv)+'" type="video/ogg">';
						}
						
						adsContent+='<video webkit-playsinline playsinline>'+(video_source)+'</video>';
						
						adsContent+='<span class="'+(_.prefix_class)+'-vid-countdown '+(_.prefix_class)+'-vid-countdown-control"></span>';
						
						if(typeof(link_target)!=='undefined' && link_target!==''){
							adsContent+='<a href="'+(link_target)+'" class="'+(_.prefix_class)+'-vid-link-target" target="_blank"></a>';
						}
						
						player.find('.'+(_.prefix_class)+'-video-ads-content-control').html(adsContent);
					
						var videoPlayer = player.find('.'+(_.prefix_class)+'-video-ads-content-control video');
						
						/*mobile*/
						if(_.getMobileOperatingSystem()){
							if(player.find('.'+(_.prefix_class)+'-first-click-on-mobile-control').length > 0){
								return;
							}
							
							player.append('<div class="'+(_.prefix_class)+'-first-click-on-mobile '+(_.prefix_class)+'-first-click-on-mobile-control"></div>');
							
							var $firstPlayVideo = player.find('.'+(_.prefix_class)+'-first-click-on-mobile-control');
							$firstPlayVideo.off('.firstClickAds').on('click.firstClickAds', function(){
								
								videoPlayer[0].load();
								$(this).addClass(_.hidden_class);
								if(!$('#'+(frame_id)).hasClass(_.hidden_class)){
									_.global_video_player[(frame_id)].playVideo();
								}								
								
							});
							
							$('#'+(frame_id)).addClass((_.prefix_class)+'-popup-loaded');
							
							return;
						}/*mobile*/
						
						/*desktop*/
						videoPlayer[0].onloadeddata = function(){							
							
							$('#'+(frame_id)).addClass((_.prefix_class)+'-popup-loaded');
							if(!$('#'+(frame_id)).hasClass(_.hidden_class) && player_autoplay && !_.getMobileOperatingSystem()){
								_.global_video_player[(frame_id)].playVideo();	
							};
												
						}/*desktop*/
						
						return;
						
					}
				}
				
				$('#'+(frame_id)).addClass((_.prefix_class)+'-popup-loaded');
				if(!$('#'+(frame_id)).hasClass(_.hidden_class) && player_autoplay && !_.getMobileOperatingSystem()){
					_.global_video_player[(frame_id)].playVideo();	
				};
		}
		
		ytGallery.prototype.video_ads = function(video_id, frame_id, video_duration, player){
			
			var _ 						= this,
				enabled 				= _.options.player_video_ads.enabled,
				ad_type					= _.options.player_video_ads.ad_type,
				google_ads_client_id	= _.options.player_video_ads.google_ads_client_id,
				google_ads_slot_id 		= _.options.player_video_ads.google_ads_slot_id,
				ad_image 				= _.options.player_video_ads.ad_image,
				ad_video 				= _.options.player_video_ads.ad_video,				
				time_to_show_ads 		= _.options.player_video_ads.time_to_show_ads,
				time_skip_ads 			= _.options.player_video_ads.time_skip_ads,
				time_to_hide_ads 		= _.options.player_video_ads.time_to_hide_ads;
				
				
			if(typeof(_.global_video_ads[(frame_id)])==='undefined'){
				_.global_video_ads[(frame_id)] = [];
			}else{
				return;
			}	
			
			if(!Array.isArray(time_to_show_ads) || !_.isNumber(video_duration)){
				return;
			}
			
			var new_time_to_show_ads = [];			
			$.each(time_to_show_ads, function(i, value){
				var new_val = $.trim(value);
				if(_.isNumber(new_val)){
					new_time_to_show_ads[i] = parseFloat(new_val);
				}
			});
			
			var uniq_time_to_show_ads = 
			($.grep(new_time_to_show_ads, function(n){ 
				return n == 0 || n;
			})).slice()
			.sort(function(a,b){
				return a > b;
			})
			.reduce(function(a,b){
				if (a.slice(-1)[0] !== b) a.push(b);
				return a;
			},[]);
			
			var vd = parseFloat(video_duration);			
						
			if(enabled && uniq_time_to_show_ads.length>0 && _.isNumber(time_skip_ads) && _.isNumber(time_to_hide_ads)){
				var adsContent = '';									
									
				if(ad_type==='ga' && google_ads_client_id!=='' || google_ads_slot_id!==''){
					adsContent = 	'<ins class="adsbygoogle" style="display:block" data-ad-client="'+(google_ads_client_id)+'" data-ad-slot="'+(google_ads_slot_id)+'" data-ad-format="auto"></ins>';
				}
				
				if(ad_type==='img' && Array.isArray(ad_image) && ad_image.length>0){
										
					var objectRand = ad_image[Math.floor(Math.random() * ad_image.length)],
					img_source = objectRand.img,
					img_link = objectRand.link_target;
					
					if(typeof(img_source)==='undefined' || img_source===''){
						return;
					}
					
					player.find('.'+(_.prefix_class)+'-video-ads-content-control').addClass((_.prefix_class)+'-type-img-ad');
					
					if(typeof(img_link)!=='undefined' && img_link!==''){
						adsContent+='<a href="'+(img_link)+'" target="_blank">';
					}
						adsContent+='<img class="'+(_.prefix_class)+'-img-ads-control" src="'+(img_source)+'">';
						
					if(typeof(img_link)!=='undefined' && img_link!==''){
						adsContent+='</a>';
					}	
				}
				
				if(ad_type==='vid' && Array.isArray(ad_video) && ad_video.length>0){					
					adsContent = 'vid-ready';
				}
				
				if(adsContent===''){
					return;
				}													
									
				$.each(uniq_time_to_show_ads, function(i, value){
					if(_.isNumber(value)){
						
						var timeOutAds = null,
							t_ads = parseFloat(value);
							
						var iframeAdsAction = function(){
														
							if(timeOutAds!==null){
								clearInterval(timeOutAds);
							}
							
							_.global_video_player[(frame_id)].pauseVideo();
							
							var timeOutHideAds = null,
								timeOutSkipAds = null;
							
							$(window).resize(function(){
								if(screenfull.isFullscreen){
									player.addClass((_.prefix_class)+'-set-fs');	
								}else{
									player.removeClass((_.prefix_class)+'-set-fs');	
								};
							});
							
							if(screenfull.isFullscreen){
								player.addClass((_.prefix_class)+'-set-fs');
							};
							
							player
							.addClass((_.prefix_class)+'-running-ads')
							.find('.'+(_.prefix_class)+'-video-ads-control').addClass(_.active_class);
							
							
							if(ad_type!=='vid'){
								player.find('.'+(_.prefix_class)+'-video-ads-content-control').html(adsContent);								
								if(ad_type==='ga' && !$('#'+(frame_id)).hasClass(_.hidden_class)){
									_.setGoogleAds();
								}								
							}
							
							player.find('.'+(_.prefix_class)+'-skip-ads-control').off('.clickSkipAds').on('click.clickSkipAds', function(){								
								var $t_btn = $(this);
								
								if(timeOutHideAds!==null){
									clearTimeout(timeOutHideAds);
								}
								
								if(timeOutSkipAds!==null){
									clearInterval(timeOutSkipAds);
								}
								
								if(ad_type==='vid'){
									player.find('.'+(_.prefix_class)+'-vid-countdown-control').text('');
									player.find('.'+(_.prefix_class)+'-video-ads-content-control').children().filter('video').each(function(){
										
										/*this.onabort = null;
										this.onerror = null;
										this.oncanplay = null;
										this.ontimeupdate = null;
										this.onended = null;*/										
										this.pause();										
										/*delete this; /*@sparkey reports that this did the trick (even though it makes no sense!)*/
										/*$(this).remove();*/
										this.addEventListener('loadedmetadata', function() {
											this.currentTime = 0;
										}, false);
										
										this.load();
										
									});
								}
																
								player
								.removeClass((_.prefix_class)+'-set-fs '+(_.prefix_class)+'-running-ads')
								.find('.'+(_.prefix_class)+'-video-ads-control').removeClass(_.active_class);
								
								if(ad_type!=='vid'){
									player.find('.'+(_.prefix_class)+'-video-ads-content-control').html('');
								}
								
								player.find('.'+(_.prefix_class)+'-text-load-ads-control').removeClass(_.hidden_class);
								
								player.find('.'+(_.prefix_class)+'-close-load-ads-control').removeClass((_.prefix_class)+'-progress-time '+(_.prefix_class)+'-transition-timing').width('100%').stop();
								
								player.find('.'+(_.prefix_class)+'-skip-seconds-control').text(time_skip_ads);
								
								$t_btn.removeClass(_.active_class);
								
								if(!$('#'+(frame_id)).hasClass(_.hidden_class)){
									_.global_video_player[(frame_id)].playVideo();
								};								
								
							});
							
							player.find('.'+(_.prefix_class)+'-skip-seconds-control').text(time_skip_ads);
							
							var classCheckLoad = ' iframe';							
							if(ad_type==='img'){
								classCheckLoad = ' .'+(_.prefix_class)+'-img-ads-control';
							}
							
							if(ad_type==='ga'){								
								player.find('.'+(_.prefix_class)+'-video-ads-content-control'+classCheckLoad).load(function(){
									
									/*same*/
									player.find('.'+(_.prefix_class)+'-text-load-ads-control').addClass(_.hidden_class);																	
									player.find('.'+(_.prefix_class)+'-close-load-ads-control')
									.stop()
									.width('100%')
									.addClass((_.prefix_class)+'-progress-time')
									.animate({width:0},time_to_hide_ads*1000, 'linear');
									
									timeOutHideAds = setTimeout(function(){	
																	
										clearTimeout(timeOutHideAds);									
										player.find('.'+(_.prefix_class)+'-skip-ads-control').trigger('click');
										
									}, time_to_hide_ads * 1000);
									
									var currentSkipSeconds = time_skip_ads;
									timeOutSkipAds = setInterval(function(){
										
										currentSkipSeconds--;
										if(currentSkipSeconds===0){
											clearInterval(timeOutSkipAds);
											player.find('.'+(_.prefix_class)+'-skip-ads-control').addClass(_.active_class);
										}
										player.find('.'+(_.prefix_class)+'-skip-seconds-control').text(currentSkipSeconds);
										
									},1000);/*same*/
									
								});

								
								if(player.find('.'+(_.prefix_class)+'-video-ads-content-control'+classCheckLoad).length === 0){
									setTimeout(function(){
										if(player.find('.'+(_.prefix_class)+'-video-ads-content-control'+classCheckLoad).length > 0){
											
											/*same*/
											player.find('.'+(_.prefix_class)+'-text-load-ads-control').addClass(_.hidden_class);																	
											player.find('.'+(_.prefix_class)+'-close-load-ads-control')
											.stop()
											.width('100%')
											.addClass((_.prefix_class)+'-progress-time')
											.animate({width:0},time_to_hide_ads*1000, 'linear');
											
											timeOutHideAds = setTimeout(function(){	
																			
												clearTimeout(timeOutHideAds);									
												player.find('.'+(_.prefix_class)+'-skip-ads-control').trigger('click');
												
											}, time_to_hide_ads * 1000);
											
											var currentSkipSeconds = time_skip_ads;
											timeOutSkipAds = setInterval(function(){
												
												currentSkipSeconds--;
												if(currentSkipSeconds===0){
													clearInterval(timeOutSkipAds);
													player.find('.'+(_.prefix_class)+'-skip-ads-control').addClass(_.active_class);
												}
												player.find('.'+(_.prefix_class)+'-skip-seconds-control').text(currentSkipSeconds);
												
											},1000);/*same*/
											
										}else{
											player.find('.'+(_.prefix_class)+'-skip-ads-control').trigger('click');
										}
									}, 1368);
								}
							}
							
							if(ad_type==='img'){
								player.find('.'+(_.prefix_class)+'-video-ads-content-control'+classCheckLoad).load(function(){
									player.find('.'+(_.prefix_class)+'-text-load-ads-control').addClass(_.hidden_class);
																	
									player.find('.'+(_.prefix_class)+'-close-load-ads-control')
									.stop()
									.width('100%')
									.addClass((_.prefix_class)+'-progress-time')
									.animate({width:0},time_to_hide_ads*1000, 'linear');
									
									timeOutHideAds = setTimeout(function(){	
																	
										clearTimeout(timeOutHideAds);									
										player.find('.'+(_.prefix_class)+'-skip-ads-control').trigger('click');
										
									}, time_to_hide_ads * 1000);
									
									var currentSkipSeconds = time_skip_ads;
									timeOutSkipAds = setInterval(function(){
										
										currentSkipSeconds--;
										if(currentSkipSeconds===0){
											clearInterval(timeOutSkipAds);
											player.find('.'+(_.prefix_class)+'-skip-ads-control').addClass(_.active_class);
										}
										player.find('.'+(_.prefix_class)+'-skip-seconds-control').text(currentSkipSeconds);
										
									},1000);
								});
							}
							
							if(ad_type==='vid'){	
								var videoPlayer = player.find('.'+(_.prefix_class)+'-video-ads-content-control video');
								if(videoPlayer.length>0){									
																		
									videoPlayer[0].onerror = function(){
										player.find('.'+(_.prefix_class)+'-skip-ads-control').trigger('click');
									}
									
									videoPlayer[0].onended = function(){
										player.find('.'+(_.prefix_class)+'-skip-ads-control').trigger('click');
									}
									
									videoPlayer[0].ontimeupdate = function(){
										var videoDuration = videoPlayer[0].duration;																		
										player.find('.'+(_.prefix_class)+'-vid-countdown-control').text(moment((videoDuration-videoPlayer[0].currentTime)*1000).format('mm:ss'));
										if(videoPlayer[0].currentTime>0 && !player.find('.'+(_.prefix_class)+'-text-load-ads-control').hasClass(_.hidden_class)){
											player.find('.'+(_.prefix_class)+'-text-load-ads-control').addClass(_.hidden_class);
										}
										if(time_skip_ads<=videoPlayer[0].currentTime){
											player.find('.'+(_.prefix_class)+'-skip-ads-control').addClass(_.active_class);
										}else{
											player.find('.'+(_.prefix_class)+'-skip-seconds-control').text(Math.ceil(time_skip_ads-videoPlayer[0].currentTime));
										}																					
									}
									
									if(!$('#'+(frame_id)).hasClass(_.hidden_class)){
										videoPlayer[0].play();
									}																		
								}else{
									player.find('.'+(_.prefix_class)+'-skip-ads-control').trigger('click');
								}
							}
							
							_.global_video_player[(frame_id)].pauseVideo();														
						}	
						
						if(t_ads<vd && typeof(_.global_video_ads[(frame_id)][i])==='undefined'){
							
							if(i===uniq_time_to_show_ads.length-1){
								timeOutAds = setInterval(function(){									
									if(_.global_video_player[(frame_id)].getCurrentTime()>=t_ads && _.global_video_player[(frame_id)].getPlayerState()===1){
										iframeAdsAction();
									}
								},200);
							}else{
								timeOutAds = setInterval(function(){									
									if(	_.global_video_player[(frame_id)].getCurrentTime()>=t_ads 
										&& _.global_video_player[(frame_id)].getCurrentTime()<uniq_time_to_show_ads[i+1] 
										&& _.global_video_player[(frame_id)].getPlayerState()===1
									){
										iframeAdsAction();							
									}
								},200);
							}
							
							_.global_video_ads[(frame_id)][i] = true;						
						}						
					}					
				});
			}
		}
		/*video ads*/
	/*data control: 8*/
	
	/*data control: 9 - return HTML for layout*/
	ytGallery.prototype.build_item_html = function(items){
		
		var _ = this;
		
		if(_.options.debug){
			console.log('Setup: 9 - before');
		}
		
		if(!Array.isArray(items)){
			return;
		}
		
		var template 						= '',
			html 							= '',
			layout = 						_.options.layout,
			style = 						_.options.style,
			layout_title = 					_.options.layout_title,
			layout_title_one_line =			_.options.layout_title_one_line?(' '+(_.prefix_class)+'-limit-1line'):'',
			layout_description = 			_.options.layout_description,
			layout_duration = 				_.options.layout_duration,			
			layout_views_counter = 			_.options.layout_views_counter,
			layout_likes_counter = 			_.options.layout_likes_counter,
			layout_dislikes_counter = 		_.options.layout_dislikes_counter,
			layout_date = 					_.options.layout_date,
			layout_comments_counter = 		_.options.layout_comments_counter,			
			layout_play_btn =				_.options.layout_play_btn,
			
			text_views =					_.options.text_views,
			text_comments = 				_.options.text_comments,
			text_likes = 					_.options.text_likes,
			text_dislikes = 				_.options.text_dislikes,
			default_content = 				'',
			absolute_content =				'',
			gradient = 						'<div class="'+(_.prefix_class)+'-absolute-gradient '+(_.prefix_class)+'-absolute-gradient"></div>';
		
		/*default content*/	
		if(layout_title || layout_date || layout_comments_counter || layout_description || layout_views_counter || layout_likes_counter || layout_dislikes_counter){
			default_content+='<div class="'+(_.prefix_class)+'-content '+(_.prefix_class)+'-content-control">'; /*entry*/
					
				if(layout_title){						
					default_content+='<h3 class="'+(_.prefix_class)+'-title '+(_.prefix_class)+'-title-control'+(layout_title_one_line)+'">\
						<a href="{{ylink}}" target="_blank" title="{{title}}" class="'+(_.prefix_class)+'-title-link '+(_.prefix_class)+'-title-link-control \
						'+(_.prefix_class)+'-open-video-control" data-id="{{id}}" data-duration="{{duration_s}}">{{title}}</a>\
					</h3>'; /*entry-title*/
				}
				
				if(layout_date || layout_comments_counter){
					default_content+='<div class="'+(_.prefix_class)+'-metas '+(_.prefix_class)+'-metas-top '+(_.prefix_class)+'-metas-control">', /*posted-on*/
						default_content+='<div class="'+(_.prefix_class)+'-metas-wrap '+(_.prefix_class)+'-metas-wrap-control">';
							
							if(layout_date){								
								default_content+='<div class="'+(_.prefix_class)+'-date '+(_.prefix_class)+'-date-control"><i class="fa fa-calendar-check-o" aria-hidden="true"></i> <span>{{date}}</span></div>';
							}
							
							if(layout_comments_counter){
								default_content+='<div class="'+(_.prefix_class)+'-comments '+(_.prefix_class)+'-comments-control" title="'+(text_comments)+': {{comments_counter_c}}">\
									<i class="fa fa-commenting" aria-hidden="true"></i> <span>{{comments_counter}}</span>\
								</div>';
							}
							
						default_content+='</div>';
					default_content+='</div>';
				}
				
				if(layout_description){
					default_content+='{{{description}}}';
				}
				
				if(layout_views_counter || layout_likes_counter || layout_dislikes_counter){
					default_content+='<div class="'+(_.prefix_class)+'-metas '+(_.prefix_class)+'-metas-bottom '+(_.prefix_class)+'-metas-control">', /*posted-on*/
						default_content+='<div class="'+(_.prefix_class)+'-metas-wrap '+(_.prefix_class)+'-metas-wrap-control">';
							
							if(layout_views_counter){
								default_content+='<div class="'+(_.prefix_class)+'-views '+(_.prefix_class)+'-views-control" title="'+(text_views)+': {{views_counter_c}}">\
									<i class="fa fa-eye" aria-hidden="true"></i> <span>{{views_counter}}</span>\
								</div>';
							}
							
							if(layout_likes_counter){
								default_content+='<div class="'+(_.prefix_class)+'-likes '+(_.prefix_class)+'-likes-control" title="'+(text_likes)+': {{likes_counter_c}}">\
									<i class="fa fa-thumbs-up" aria-hidden="true"></i> <span>{{likes_counter}}</span>\
								</div>';
							}
							
							if(layout_dislikes_counter){
								default_content+='<div class="'+(_.prefix_class)+'-dislikes '+(_.prefix_class)+'-dislikes-control" title="'+(text_dislikes)+': {{dislikes_counter_c}}">\
									<i class="fa fa-thumbs-down" aria-hidden="true"></i> <span>{{dislikes_counter}}</span>\
								</div>';
							}
							
						default_content+='</div>';
					default_content+='</div>';
				}
				
			default_content+='</div>';
		}/*default content*/	
		
		/*absolute content*/
		if(layout_title || layout_date || layout_comments_counter || layout_description || layout_views_counter || layout_likes_counter || layout_dislikes_counter){			
			absolute_content+='<div class="'+(_.prefix_class)+'-ab-content '+(_.prefix_class)+'-content-ab-control">';
				if(layout_title){						
					absolute_content+='<h3 class="'+(_.prefix_class)+'-title '+(_.prefix_class)+'-title-control'+(layout_title_one_line)+'">\
						<a href="{{ylink}}" target="_blank" title="{{title}}" class="'+(_.prefix_class)+'-title-link '+(_.prefix_class)+'-title-link-control \
						'+(_.prefix_class)+'-open-video-control" data-id="{{id}}" data-duration="{{duration_s}}">{{title}}</a>\
					</h3>'; /*entry-title*/
				}
				if(layout_date || layout_comments_counter || layout_views_counter || layout_likes_counter || layout_dislikes_counter){
					absolute_content+='<div class="'+(_.prefix_class)+'-metas '+(_.prefix_class)+'-metas-top '+(_.prefix_class)+'-metas-control">', /*posted-on*/
						absolute_content+='<div class="'+(_.prefix_class)+'-metas-wrap '+(_.prefix_class)+'-metas-wrap-control">';
							
							if(layout_date){								
								absolute_content+='<div class="'+(_.prefix_class)+'-date '+(_.prefix_class)+'-date-control"><i class="fa fa-calendar-check-o" aria-hidden="true"></i> <span>{{date}}</span></div>';
							}
							
							if(layout_views_counter){
								absolute_content+='<div class="'+(_.prefix_class)+'-views '+(_.prefix_class)+'-views-control" title="'+(text_views)+': {{views_counter_c}}">\
									<i class="fa fa-eye" aria-hidden="true"></i> <span>{{views_counter}}</span>\
								</div>';
							}
							
							if(layout_likes_counter){
								absolute_content+='<div class="'+(_.prefix_class)+'-likes '+(_.prefix_class)+'-likes-control" title="'+(text_likes)+': {{likes_counter_c}}">\
									<i class="fa fa-thumbs-up" aria-hidden="true"></i> <span>{{likes_counter}}</span>\
								</div>';
							}
							
							if(layout_dislikes_counter){
								absolute_content+='<div class="'+(_.prefix_class)+'-dislikes '+(_.prefix_class)+'-dislikes-control" title="'+(text_dislikes)+': {{dislikes_counter_c}}">\
									<i class="fa fa-thumbs-down" aria-hidden="true"></i> <span>{{dislikes_counter}}</span>\
								</div>';
							}
							
							if(layout_comments_counter){
								absolute_content+='<div class="'+(_.prefix_class)+'-comments '+(_.prefix_class)+'-comments-control" title="'+(text_comments)+': {{comments_counter_c}}">\
									<i class="fa fa-commenting" aria-hidden="true"></i> <span>{{comments_counter}}</span>\
								</div>';
							}
							
						absolute_content+='</div>';
					absolute_content+='</div>';
				}
				
			absolute_content+='</div>';/*absolute content*/	
		}
		
		var slide_class = '';
		if(layout==='carousel'){
			slide_class = ' swiper-slide';
		}
		
		if(layout==='grid' && style==='grid-classic-1'){			
			absolute_content = '';
			gradient = '';
			
		}else if(layout==='grid' && style==='grid-special-1'){			
			default_content='';
			
		}else if(layout==='list' && style==='list-classic-1'){
			absolute_content = '';
			gradient = '';
			
		}else if(layout==='list' && style==='list-classic-2'){
			absolute_content = '';
			gradient = '';
			
		}else if(layout==='list' && style==='list-special-1'){
			absolute_content = '';
			gradient = '';
			
		}else if(layout==='carousel' && style==='carousel-classic-1'){			
			absolute_content = '';
			gradient = '';
			
		}else if(layout==='carousel' && style==='carousel-special-1'){			
			default_content='';
			
		}	
			
		template+='<div class="'+(_.prefix_class)+'-item '+(_.prefix_class)+'-item-control'+(slide_class)+'">'; /*hentry*/
			template+='<div class="'+(_.prefix_class)+'-entry-wrapper '+(_.prefix_class)+'-entry-wrapper-control">'; /*entry-content*/
			
				template+='<div class="'+(_.prefix_class)+'-picture '+(_.prefix_class)+'-picture-control">';
					template+='<div class="'+(_.prefix_class)+'-picture-wrap '+(_.prefix_class)+'-picture-wrap-control">';
						template+='<a href="{{ylink}}" target="_blank" title="{{title}}" class="'+(_.prefix_class)+'-pic-link '+(_.prefix_class)+'-pic-link-control \
								'+(_.prefix_class)+'-open-video-control"  data-id="{{id}}" data-duration="{{duration_s}}" data-img="{{small_img}}">';
						
							template+='{{{img}}}';
							
							template+=gradient;
							
							template+='<span class="'+(_.prefix_class)+'-overlay '+(_.prefix_class)+'-overlay-control"></span>';
							
							if(layout_play_btn){
								template+='<span class="'+(_.prefix_class)+'-btn-play '+(_.prefix_class)+'-btn-play-control"></span>';
							}
							
							if(layout_duration){
								template+='<span class="'+(_.prefix_class)+'-duration '+(_.prefix_class)+'-duration-control">{{duration}}</span>';
							}
														
						template+='</a>';
						template+=absolute_content;
					template+='</div>';
				template+='</div>';
			
				template+=default_content;
									
			template+='</div>';
		template+='</div>';	
		
		$.each(items, function(i, value){
			var item_data = {
					id:						value.id,
					img:					_.img_src_set(value.snippet.thumbnails, value.snippet.title),
					small_img:				value.snippet.thumbnails.default.url,
					title: 					value.snippet.title,
					description:			_.yt_description(value.snippet.description, true, false),
					duration: 				_.YTDurationToSeconds(value.contentDetails.duration),
					duration_s:				moment.duration(value.contentDetails.duration).asSeconds(),
					date: 					moment(value.snippet.publishedAt).fromNow(),
					
					views_counter: 			(typeof(value.statistics)!=='undefined' && typeof(value.statistics.viewCount)!=='undefined')?_.nFormatter(parseFloat(value.statistics.viewCount), 1):0,
					likes_counter: 			(typeof(value.statistics)!=='undefined' && typeof(value.statistics.likeCount)!=='undefined')?_.nFormatter(parseFloat(value.statistics.likeCount), 1):0,
					dislikes_counter: 		(typeof(value.statistics)!=='undefined' && typeof(value.statistics.dislikeCount)!=='undefined')?_.nFormatter(parseFloat(value.statistics.dislikeCount), 1):0,				
					comments_counter: 		(typeof(value.statistics)!=='undefined' && typeof(value.statistics.commentCount)!=='undefined')?_.nFormatter(parseFloat(value.statistics.commentCount), 1):0,
					
					views_counter_c: 		(typeof(value.statistics)!=='undefined' && typeof(value.statistics.viewCount)!=='undefined')?_.cFormatter(parseFloat(value.statistics.viewCount), 1):0,
					likes_counter_c: 		(typeof(value.statistics)!=='undefined' && typeof(value.statistics.likeCount)!=='undefined')?_.cFormatter(parseFloat(value.statistics.likeCount), 1):0,
					dislikes_counter_c: 	(typeof(value.statistics)!=='undefined' && typeof(value.statistics.dislikeCount)!=='undefined')?_.cFormatter(parseFloat(value.statistics.dislikeCount), 1):0,				
					comments_counter_c: 	(typeof(value.statistics)!=='undefined' && typeof(value.statistics.commentCount)!=='undefined')?_.cFormatter(parseFloat(value.statistics.commentCount), 1):0,
					
					ylink:					'https://www.youtube.com/watch?v='+(value.id),
				}				
			html+=Mustache.render(template, item_data);
		});
		
		if(_.options.debug){
			console.log('Setup: 9 - after');
		}
		
		return html;
	}
		/*format number to ,*/
		ytGallery.prototype.cFormatter = function(x) {
			
			if(isNaN(x)){
				return '0';
			}
			
			return x.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
		}/*format number to ,*/
		
		/*big number format*/
		ytGallery.prototype.nFormatter = function(num, digits){	
			
			if(isNaN(num)){
				return '0';
			}
			
			var si = [
					{ value: 1E18, symbol: "E" },
					{ value: 1E15, symbol: "P" },
					{ value: 1E12, symbol: "T" },
					{ value: 1E9,  symbol: "G" },
					{ value: 1E6,  symbol: "M" },
					{ value: 1E3,  symbol: "k" }
				],
				rx = /\.0+$|(\.[0-9]*[1-9])0+$/, 
				i;
			for (var i=0; i<si.length;i++) {
				if(num>=si[i].value) {
					return (num / si[i].value).toFixed(digits).replace(rx, "$1") + si[i].symbol;
				}
			}
			return num.toFixed(digits).replace(rx, "$1");
		}/*big number format*/
		
		/*convert youtube duration to time (h:m:s)*/
		ytGallery.prototype.YTDurationToSeconds = function(duration) {
			var _		= this,
				match 	= duration.match(/PT(\d+H)?(\d+M)?(\d+S)?/),
				hours 	= (parseInt(match[1]) || 0),
				minutes = (parseInt(match[2]) || 0),
				seconds = (parseInt(match[3]) || 0);	
			
			return ( (hours > 0 ? (hours>=10?hours+':':'0'+hours+':') : '') + (minutes > 0 ? (minutes>=10?minutes+':':'0'+minutes+':') : '00:') + (seconds  > 0 ? (seconds>=10?seconds:'0'+seconds) : '00') );
		}/*convert youtube duration to time (h:m:s)*/
			
		/*convert img youtube to retina*/
		ytGallery.prototype.img_src_set = function(imgs, alt){
					
			var _ 		= this,
				size 	= _.options.layout_img_size;
			
			if(typeof(imgs)!=='object'){
				return '';
			}
			
			var srcset = '';
			var i = 0,
				z = 0;
			
			switch(size){ /*video_item.snippet.thumbnails*/			
				case 'default':
					z = 1;
					break;				
					
				case 'medium':
					z = 2;
					break;
					
				case 'high':
					z = 3;
					break;
					
				case 'standard':
					z = 4;
					break;
					
				case 'maxres':
					z = 5;
					break;
					
				default:
					z = 6;
					break;					
			}
			
			$.each(imgs, function(key, value){
				i++;
				if(i===Object.keys(imgs).length){
					srcset+=value.url+' '+value.width+'w';
				}else if(i>=z){
					srcset+=value.url+' '+value.width+'w, ';
				}					
			});		
			
			var img_class = ((_.prefix_class)+'-img '+(_.prefix_class)+'-img-control');	
			
			switch(size){ /*video_item.snippet.thumbnails*/			
				case 'default':
					if(typeof(imgs.default)==='undefined'){
						return '';
					}
					return '<img src="'+(imgs.default.url)+'" alt="'+(alt)+'" srcset="'+(srcset)+'" sizes="(max-width: 120px) 100vw, 120px" class="'+(img_class)+'">';
					break;				
					
				case 'medium':
					if(typeof(imgs.medium)==='undefined'){
						return '';
					}
					return '<img src="'+(imgs.medium.url)+'" alt="'+(alt)+'" srcset="'+(srcset)+'" sizes="(max-width: 320px) 100vw, 320px" class="'+(img_class)+'">';
					break;
					
				case 'high':
					if(typeof(imgs.high)==='undefined'){
						return '';
					}
					return '<img src="'+(imgs.high.url)+'" alt="'+(alt)+'" srcset="'+(srcset)+'" sizes="(max-width: 480px) 100vw, 480px" class="'+(img_class)+'">';
					break;
					
				case 'standard':
					if(typeof(imgs.standard)==='undefined'){
						return '';
					}
					return '<img src="'+(imgs.standard.url)+'" alt="'+(alt)+'" srcset="'+(srcset)+'" sizes="(max-width: 640px) 100vw, 640px" class="'+(img_class)+'">';
					break;
					
				case 'maxres':
					if(typeof(imgs.maxres)==='undefined'){
						return '';
					}
					return '<img src="'+(imgs.maxres.url)+'" alt="'+(alt)+'" srcset="'+(srcset)+'" sizes="(max-width: 1280px) 100vw, 1280px" class="'+(img_class)+'">';
					break;
					
				default:
					if(typeof(imgs.default)==='undefined'){
						return '';
					}
					return '<img src="'+(imgs.default.url)+'" alt="'+(alt)+'" srcset="'+(srcset)+'" sizes="(max-width: 120px) 100vw, 120px" class="'+(img_class)+'">';
					break;					
			}
		}/*convert img youtube to retina*/	
		
		/*description*/
		ytGallery.prototype.replaceAll = function(str, find, replace) {
			return str.replace(new RegExp(find, 'g'), replace);
		}
		ytGallery.prototype.yt_description = function(des, cut, br){
			var _ = this;		
			if(typeof(des)!=='undefined' && des!==''){
				var _ 							= this,
					layout_description_length 	= _.options.layout_description_length,
					before 						= '<div class="'+(_.prefix_class)+'-excerpt '+(_.prefix_class)+'-excerpt-control">',
					after 						= '</div>';
				
				if(br){
					des = _.replaceAll(des, '\n', '<br>');
				}
					
				if(des.length > layout_description_length && cut){
					return (before)+(des.substring(0, layout_description_length))+'...'+(after);
				}else{
					return (before)+(des)+(after);
				}
			}else{
				return '';
			}
		}/*description*/
	/*data control: 9*/
	
	/*destroy*/
	ytGallery.prototype.destroy = function(){
		var _ = this;		
	}/*destroy*/
	
	/*jquery*/
	$.fn.J_ytGallery = function(){
		var _ 		= this,
			opt 	= arguments[0],
			args 	= Array.prototype.slice.call(arguments, 1),
			l 		= _.length,
			i,
			ret;
		for(i = 0; i < l; i++) {
			if(typeof opt == 'object' || typeof opt == 'undefined'){
				_[i].J_ytGallery = new ytGallery(_[i], opt);
			}else{
				ret = _[i].J_ytGallery[opt].apply(_[i].J_ytGallery, args);
			}
			if (typeof ret != 'undefined'){				
				return ret;
			}
		}
		return _;
	}/*jquery*/
	
	/*create event when library ready*/
	$(document).ready(function(){
		
		setTimeout(function(){
			if($('script[src*="youtube.com/iframe_api"]').length>0 || $('script[src*="www-widgetapi.js"]').length>0){			
			
				var triggerInterval = setInterval(function(){
					console.log('Youtube Video Gallery: Request API.');
					if(typeof(YT)!=='undefined' && typeof(YT.Player)!=='undefined'){
						$(document).trigger('youtubeVideoGalleryReady', []);
						clearInterval(triggerInterval);
						console.log('Youtube Video Gallery: Api Ready.');
					}
				},368);			
				
			}else{
				var you_gall_YTdeferred = $.Deferred();	
				
				window.onYouTubeIframeAPIReady = function(){
					you_gall_YTdeferred.resolve(window.YT);
				}
						
				var tag = document.createElement('script');
				tag.src = "https://www.youtube.com/iframe_api";
				var firstScriptTag = document.getElementsByTagName('script')[0];
				firstScriptTag.parentNode.insertBefore(tag, firstScriptTag);
			
				you_gall_YTdeferred.done(function(YT){
					$(document).trigger('youtubeVideoGalleryReady', []);
				});
			}
		},368);
		
		/*
		var youtubeVideoGalleryReady = false;

		window.onYouTubeIframeAPIReady = function(){
			if(youtubeVideoGalleryReady){		
				return;
			}
			youtubeVideoGalleryReady = true;
			$(document).trigger('youtubeVideoGalleryReady', []);
		}
		
		if(!youtubeVideoGalleryReady){
			$('#youtubeVideoGalleryReady').remove();
			var tag = $('<script></script>').attr({
				'src'	: '//www.youtube.com/iframe_api?v=' + Math.floor((Math.random() * 1000) + 1),
				'id'	: 'youtubeVideoGalleryReady'
			});
			$('head').prepend(tag);
		}else{
			setTimeout(function(){
				$(document).trigger('youtubeVideoGalleryReady', []);
			},100);
		}
		*/
		
	});/*create event when library ready*/
			
}));